#!/usr/bin/env bash

# created by chatterjee arnab

if [ $# -eq 0 ]; then
	echo usage: $0 [ubuntu release name]
	exit 1
fi
set -e

apt install -y software-properties-common
add-apt-repository -y ppa:deadsnakes/ppa
apt install -y gnupg ca-certificates
apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 3FA7E0328081BFF6A14DA29AA6A19B38D3D831EF
echo deb https://download.mono-project.com/repo/ubuntu stable-$1 main | tee /etc/apt/sources.list.d/mono-official-stable.list
dpkg --add-architecture i386
wget -qt0 --show-progress -O- https://dl.winehq.org/wine-builds/winehq.key | apt-key add -
apt-add-repository -y deb\ https://dl.winehq.org/wine-builds/ubuntu/\ $1\ main
apt update
apt install -y python3.6 mono-devel nuget
apt install -y --install-recommends winehq-stable

wget -qt0 --show-progress https://github.com/fsharp/fsharp/archive/4.0.1.9.tar.gz
tar xzf 4.0.1.9.tar.gz
cd fsharp-4.0.1.9/
sed -i s#MONOPREFIX=.*#MONOPREFIX=/usr# configure.ac
sed -i s#\"/usr/local\"## src/utils/CompilerLocationUtils.fs
./autogen.sh --prefix=/usr --with-gacdir=/usr/lib/mono/gac
sed -i s#=/usr/local#=/usr# configure
sed -i s#=/usr/local#=/usr# autom4te.cache/output.*
make
make install
cd ../

./VC.py --accept-license --ignores ASAN CodeSense CoreEditor CoreIDE Debugger DIA.SDK Editors IntelliTrace LiveShareApi OneCore SccCodeLenses UnitTest TestTools WebSiteProject WebTools Windows10SDK
mv .../VC/Tools/MSVC/* VC/
cd VC/
mv bin/Hostx86/x86/ x86/
rm -rf bin/
mv x86/ bin/
wget -qt0 --show-progress -Oinclude/corecrt.h https://raw.githubusercontent.com/tpn/winsdk-10/master/Include/10.0.16299.0/ucrt/corecrt.h
cd ../

xbuild VCC/Vcc.sln

mv VC/ /opt/VC/
mv VCC/ /opt/VCC/
echo "
alias vcc='WINEDEBUG=-all wine /opt/VCC/vcc/Host/bin/Release/vcc.exe'" >> ~/.bashrc
rm -rf .../ fsharp-4.0.1.9/ 4.0.1.9.tar.gz VCC.tar.gz VC.py $0

