package akka.chatroom;

import akka.actor.typed.*;
import akka.actor.typed.javadsl.*;
public class Gabbler  extends AbstractBehavior<ChatRoom.SessionEvent> {
	int  messageCount = 0;
	ActorRef<ChatRoom.PostMessage> mySession;
	
	public static Behavior<ChatRoom.SessionEvent> create() {
		return Behaviors.setup(Gabbler::new); // Gabbler::new is a function of type
											  // ActorContext<ChatRoom.SessionEvent> -> Gabbler
		// equivalent to "return new Gabbler();"
	}

	private Gabbler(ActorContext<ChatRoom.SessionEvent> context) {
		super(context);
	}

	@Override
	public Receive<ChatRoom.SessionEvent> createReceive() {
		ReceiveBuilder<ChatRoom.SessionEvent> builder = newReceiveBuilder();
		return builder
				.onMessage(ChatRoom.SessionDenied.class, this::onSessionDenied)
				.onMessage(ChatRoom.SessionGranted.class, this::onSessionGranted)
				.onMessage(ChatRoom.MessagePosted.class, this::onMessagePosted)
				.build();
	}

	private Behavior<ChatRoom.SessionEvent> onSessionDenied(ChatRoom.SessionDenied message) {
		getContext().getLog().info("Gabbler was not granted chat room session due to: {}", message.reason);
		return Behaviors.stopped();
	}

	private Behavior<ChatRoom.SessionEvent> onSessionGranted(ChatRoom.SessionGranted message) {
		mySession = message.handle;
		mySession.tell(new ChatRoom.PostMessage("Hello World " + messageCount + "!"));
		return this;
	}

	private Behavior<ChatRoom.SessionEvent> onMessagePosted(ChatRoom.MessagePosted message) {
		getContext()
		.getLog()
		.info("message '{}' posted by '{}' received by Gabbler", message.message, message.screenName);
		if (messageCount < 5) {
			messageCount++;
			mySession.tell(new ChatRoom.PostMessage("Hello World " + messageCount + "!"));
			return this;
		}
		else return Behaviors.stopped(); // Note, 
			// sometimes we end up stopping
			// the client even before all replies have been received. 
			// This is seen from the Undelivered warnings in the Console.
	}
}
