package akka.chatroom;

import akka.actor.typed.*;
import akka.actor.typed.javadsl.*;

public class Main {
	public static Behavior<Void> create() {
	    return Behaviors.setup(
	        context -> {
	          ActorRef<ChatRoom.RoomCommand> chatRoom = context.spawn(ChatRoom.create(), "chatRoom");
	          ActorRef<ChatRoom.SessionEvent> gabbler1 = context.spawn(Gabbler.create(), "gabbler1");
	          ActorRef<ChatRoom.SessionEvent> gabbler2 = context.spawn(Gabbler.create(), "gabbler2");

	          //context.watch(gabbler1);
	          //context.watch(gabbler2);

	          chatRoom.tell(new ChatRoom.GetSession("ol’ Gabbler", gabbler1));
	          chatRoom.tell(new ChatRoom.GetSession("nu’ Gabbler", gabbler2));

	          
	          return Behaviors.empty(); // don't want to receive any more messages
	       
	          // We can return an empty behavior, because we are returning the user-guardian actor, and
	          // normally this actor need not receive any messages.
	        });
	  }

	  public static void main(String[] args) {
	    ActorSystem.create(Main.create(), "ChatRoomDemo"); // spawn "user guardian" actor
	  }
}
