package sample.cluster.simple;


import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.Behaviors;

import akka.cluster.sharding.typed.javadsl.Entity;
import akka.cluster.sharding.typed.javadsl.EntityTypeKey;
import akka.persistence.typed.PersistenceId;
import akka.cluster.sharding.typed.javadsl.ClusterSharding;
import akka.cluster.sharding.typed.javadsl.EntityRef;

import java.io.Console;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;


public class App {

  public static void main(String[] args) {
	  // Create an Akka system
	   ActorSystem.create(rootBehavior(), "PersistenceDemo");
  }

  private static Behavior<Void> rootBehavior() {
    return Behaviors.setup(
       context -> 
       {
    	 ActorRef<CounterPersist.Command> ref = context.spawn(CounterPersist.create(PersistenceId.ofUniqueId("567")), "Counter");
	 /* A persistent actor (such as CounterPersist) needs to
	    extent EventSourcedBehavior (not
	    AbstractBehavior). Therefore, it is not a standard actor
	    at all. However, it can receive commands and handle them
	    like other actors. The way the command handlers are
	    written for persistent actors is different than for
	    non-persistent actors -- this was covered in class, and
	    you can see the pattern in class CounterPersist.

	    One of the arguments to the .create method must be a
	    persistence ID.  This must be globally unique across all
	    persistent actors, irrespective of their type. The
	    constructor of the persistent actor must pass the
	    persistence ID to super(), as the system needs to know
	    the persistence ID of each persistent actor.

            The class PersistenceId provides many different utility
	    functions to create persistence IDs. However, it is the
	    programmer's responsibility to ensure uniqueness of the
	    ID. In the example above, the ID is simply the string
	    "567".
	  */
	 
	 /* The spawn method call shown above has the following
 	    effect.
	 
    	    If an event log is available in the journal for
    	    persistence ID 567, then the actor just spawned will get a
    	    recovered state obtained by replaying the events stored in
    	    the log. If no event log is available for 567, the spawned
    	    actor gets a fresh state. In both cases, any new events
    	    that get generated below will get appended into the log
    	    for ID 567. */

	 /* See the file application.conf to understand the 
	    configuration parameters required for persistence. In
	    particular, the type of journal to be used needs to be
	    specified.  Similar to cluster sharding, we need to map
	    code-interfaces to serialization mechanisms within
	    application.conf, and then make the Event, Command, and
	    State types of the persistent actor inherit from these
	    interfaces so that they can be serialized. Note, it is
	    easy to see that Events need to serialized in the journal
	    logs. It is not obvious why Commands need to be serialized
	    (unless we are part of an Akka Cluster, when they have to
	    be shipped between nodes). It is not obvious why States
	    need to be serialized; perhaps this is necessary if we
	    want to compact the event logs by collapsing a long event
	    sequence into a State.

            */

	 
    	 for(int i = 0; i < 100; ++i) {
    	    	try {
    	    	  Thread.sleep(1000);
    	    	}
    	    	catch(InterruptedException e) {
    	    	}
    	    	ref.tell(new CounterPersist.Increment());
    	 };
    	 return Behaviors.empty();
       }
    );
  }
}
