#include "template_test_digraph.cpp"
#include <iostream>

//holds all node pointers
DiGraphNode ** nodes;

/*
build a directed graph from input file of format

10         <- total number of nodes
0 2 1      <- source target visibility (0 = hidden)
0 1 1
0 2 1
...
...

*/

DiGraph<NodeInfoType, EdgeInfoType> * build_graph(FILE * des)
{

	int s, t, num_node, h;
	NodeInfoType *node_info;
	EdgeInfoType *edge_info;
	DiGraph<NodeInfoType, EdgeInfoType> *map = new DiGraph<NodeInfoType, EdgeInfoType>();
	fscanf(des, "%d\n", &num_node);

	node_info = new NodeInfoType[num_node];
	edge_info = new EdgeInfoType();
	nodes =  new DiGraphNode* [ num_node];
	for (int i = 0; i < num_node; i++) {
		
		node_info[i].id = i;
		nodes[i] = map->new_node(node_info[i]);
	}
	Edge * e;
	while (fscanf(des, "%d %d %d\n", &s, &t, &h) != EOF) {
		
		cout << s << " " << t << endl;
		e= map->new_edge(nodes[t], nodes[s], *edge_info);
		if(h == 0) {
			map->hide_edge(e);
		}
	}
	delete [] node_info;
	delete edge_info;
	return map;
}

int main(int argc, char** argv) {

	DiGraph<NodeInfoType, EdgeInfoType> tgraph;


	FILE * des;

	if(argc != 2) {
	
		cout << "usage: test_graph [input file]" << endl;
		exit(1);
	}
	des = fopen(argv[1], "r");

	
	DiGraph<NodeInfoType, EdgeInfoType> * map = build_graph(des);
	cout << "all nodes:" << endl;
		
	DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator ite;
	DiGraphNode::EdgeIterator in_ite, out_ite;
	for_all_nodes(ite, *map) {
	
		cout << "node" << map->inf(*ite) <<endl;
		cout << "in edges:" << endl;
		for_all_in_edges(in_ite, (*ite)) {
			cout << map->inf(SOURCE(*in_ite)) << "->";
			cout << map->inf(TARGET(*in_ite)) << ", ";
		}

		cout << endl;
		cout << "out edges:" << endl;
		for_all_out_edges(out_ite, (*ite)) {
			cout << map->inf(SOURCE(*out_ite)) << "->";
			cout << map->inf(TARGET(*out_ite)) << ", ";
		}
		cout << endl;
	}
    cout << "all edges listing" << endl;
	DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator edge_ite;
	for_all_edges(edge_ite, *map) {
			cout << map->inf(SOURCE(*edge_ite)) << "->";
			cout << map->inf(TARGET(*edge_ite)) << ", ";
            cout << " ";
    }
    delete(map);
}

