#include "template_test_ugraph.cpp"
#include <iostream>
#include <map>
#include <set>
//holds all node pointers
UGraphNode ** nodes;


UGraph<NodeInfoType, EdgeInfoType> * build_graph(FILE * des)
{

	int s, t, num_node, h;
	NodeInfoType *node_info;
	EdgeInfoType *edge_info;
	UGraph<NodeInfoType, EdgeInfoType> *graph = new UGraph<NodeInfoType, EdgeInfoType>();
	fscanf(des, "%d\n", &num_node);

	node_info = new NodeInfoType[num_node];
	edge_info = new EdgeInfoType();
	nodes =  new UGraphNode* [ num_node];
	for (int i = 0; i < num_node; i++) {
		
		node_info[i].id = i;
		nodes[i] = graph->new_node(node_info[i]);
	}
	Edge * e;
	while (fscanf(des, "%d %d %d\n", &s, &t, &h) != EOF) {
		
		cout << s << " " << t << endl;
		e= graph->new_edge(nodes[t], nodes[s], *edge_info);
		if(h == 0) {
			graph->hide_edge(e);
		}
	}
	delete [] node_info;
	delete edge_info;
	return graph;
}


void DFS(Node *n, set<Node *>& S) {

    //visit n
    S.insert(set<Node *>::value_type(n));
    
    UGraphNode::EdgeIterator ite;
	Node * neighbor;
    for_all_adj_edges(ite, *((UGraphNode *)(n))) {
        
		if(NODE1(*ite) == n)
            neighbor = NODE2(*ite);
        else
            neighbor = NODE1(*ite);
        //if eighbor is unvisited
        if( S.find(neighbor) == S.end())
            DFS(neighbor, S);
	}
}

template<class NodeType, class EdgeType>
int
COMPONENT(UGraph<NodeType, EdgeType> * graph, map<Node *, int>& compnum) {

    typedef typename UGraph<NodeType, EdgeType>::NodeIterator ugraph_node_ite;
    set<Node *> unmarked;
    int c = -1;
    ugraph_node_ite ite;
    for_all_nodes(ite, *graph) {
        unmarked.insert(set<Node *>::value_type(*ite));
        compnum.insert(map<Node *, int>::value_type(*ite, -1));
    }
    set<Node *> S;   
    while (!unmarked.empty()){
        c++;
        S.clear();
        //get the first one as n
        Node * n = *(unmarked.begin());
        DFS(n, S);
        for(set<Node *>::iterator m = S.begin(); m != S.end(); m++) {
            
            //mark m
            unmarked.erase(*m);
            compnum[*m]=c;
        }
    }
    return c;
}


int main(int argc, char** argv) {

	UGraph<NodeInfoType, EdgeInfoType> tgraph;


	FILE * des;

	if(argc != 2) {
	
		cout << "usage: test_graph [input file]" << endl;
		exit(1);
	}
	des = fopen(argv[1], "r");

	UGraph<NodeInfoType, EdgeInfoType> * graph = build_graph(des);
	
    map<Node *, int> compnum;
    COMPONENT (graph, compnum);

    cout <<"compnum: " <<endl;

    for(map<Node *, int>::iterator mi = compnum.begin(); mi!=compnum.end();
            mi++) {
    
        cout << graph->inf((*mi).first) << " : " << (*mi).second <<endl;
    
    }
    
    
	cout << "all nodes:" << endl;
		
	UGraph<NodeInfoType, EdgeInfoType>::NodeIterator ite;
	UGraphNode::EdgeIterator in_ite, out_ite;
	for_all_nodes(ite, *graph) {
	
		cout << "node" << graph->inf(*ite) <<endl;
		cout << "adj edges:" << endl;
		for_all_adj_edges(in_ite, *(*ite)) {
			cout << graph->inf(NODE1(*in_ite)) << "->";
			cout << graph->inf(NODE2(*in_ite)) << ", ";
		}
        cout <<endl;

	}
    cout << "all edges listing" << endl;
	UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator edge_ite;
	for_all_edges(edge_ite, *graph) {
			cout << graph->inf(NODE1(*edge_ite)) << "->";
			cout << graph->inf(NODE2(*edge_ite)) << ", ";
            cout << " ";
    }
    delete(graph);
}

