#include "graph.h"
#include "undirected_graph.h"
#include <iostream>
#include <map>
#include <set>

void DFS(Node *n, set<Node *>& S) {

    //visit n
    S.insert(set<Node *>::value_type(n));
    
    UGraphNode::EdgeIterator ite;
	Node * neighbor;
    for_all_adj_edges(ite, *((UGraphNode *)(n))) {
        
		if(NODE1(*ite) == n)
            neighbor = NODE2(*ite);
        else
            neighbor = NODE1(*ite);
        //if eighbor is unvisited
        if( S.find(neighbor) == S.end())
            DFS(neighbor, S);
	}
}

template<class NodeType, class EdgeType>
int
COMPONENT(UGraph<NodeType, EdgeType> * graph, map<Node *, int>& compnum) {

    typedef typename UGraph<NodeType, EdgeType>::NodeIterator ugraph_node_ite;
    set<Node *> unmarked;
    int c = -1;
    ugraph_node_ite ite;
    for_all_nodes(ite, *graph) {
        unmarked.insert(set<Node *>::value_type(*ite));
        compnum.insert(map<Node *, int>::value_type(*ite, -1));
    }
    set<Node *> S;   
    while (!unmarked.empty()){
        c++;
        S.clear();
        //get the first one as n
        Node * n = *(unmarked.begin());
        DFS(n, S);
        for(set<Node *>::iterator m = S.begin(); m != S.end(); m++) {
            
            //mark m
            unmarked.erase(*m);
            compnum[*m]=c;
        }
    }
    return c;
}
