#ifndef __DIEDGE_HEADER__
#define __DIEDGE_HEADER__
#include "edge.h"
#include "dinode.h"
//============================================================================
// DiGraphEdge
// ===========
// Implements an edge in a directed graph, subclass of the generic Edge class
// Each DiGraphEdge is defined by an ordered pair of DiGraphNode,  
//
// Constructors
// ------------
// DiGraphEdge() 
// creates an edge with no source and target nodes specified
// Destructors
// -----------
// ~DiGrahNode()
// 
// Functions
// ---------
// Node * Source() , Target()
// returns the source/target DiGraphNode
//
//============================================================================

//edge_pt is a pointer to DiGraphEdge
#define SOURCE(edge_pt) (edge_pt)->Source()
#define TARGET(edge_pt) (edge_pt)->Target()
#define source(edge_pt) (edge_pt)->Source()
#define target(edge_pt) (edge_pt)->Target()


class DiGraphEdge : public Edge {

    template<class NodeInfoType, class EdgeInfoType> friend class DiGraph;
    friend class DiGraphNode::EdgeIterator;
    private:
        DiGraphNode * source;
        DiGraphNode * target;
    public:
        DiGraphEdge();
        ~DiGraphEdge();
        DiGraphNode * Source();
        DiGraphNode * Target();
};

#endif
