#include "dinode.h"
#include "diedge.h"
#include <iostream>
//============================================================================
// DiGraphNode::EdgeIterator Implementation
//============================================================================

DiGraphNode::EdgeIterator &DiGraphNode::EdgeIterator::operator++() {
		
	//get to the next non-hidden edge
	ite++;
	for(; ite!=edge_list->end() && (*ite)->hidden == true; ite++);
	
	return *this;
}

DiGraphNode::EdgeIterator &DiGraphNode::EdgeIterator::operator=(const DiGraphNode::EdgeIterator& edge_ite) {
	
	ite = edge_ite.ite;
	edge_list = edge_ite.edge_list;
	return *this;
}

bool DiGraphNode::EdgeIterator::operator==(const DiGraphNode::EdgeIterator& edge_ite) {

	return (ite == edge_ite.ite);
}

bool DiGraphNode::EdgeIterator::operator!=(const DiGraphNode::EdgeIterator& edge_ite) {

	return (ite != edge_ite.ite);
}

DiGraphEdge * DiGraphNode::EdgeIterator::operator*() {

	return (DiGraphEdge *) * ite;
}



//============================================================================
// DiGraphNode Implementation
//============================================================================
DiGraphNode::DiGraphNode() {
}

DiGraphNode::~DiGraphNode() {

    //memory deallocation always done by the graph
    //nothing to be done here
}


DiGraphNode::EdgeIterator DiGraphNode::InEdgeBegin() {
	
	EdgeIterator tmp;
	tmp.ite = in_edges.begin();
	//go to the first non hidden edge
	for(; tmp.ite!=in_edges.end() && (*(tmp.ite))->hidden == true; tmp.ite++);
	
	//store the pointer to in_edges in tmp
	tmp.edge_list = &(in_edges);
	
	return tmp;
}

DiGraphNode::EdgeIterator DiGraphNode::InEdgeEnd() {
	
	EdgeIterator tmp;
	tmp.ite = in_edges.end();

    //the edge_list should have been assigned by InEdgeBegin()
    //
	tmp.edge_list = &(in_edges);
	return tmp;

}

DiGraphNode::EdgeIterator DiGraphNode::OutEdgeBegin() {
	
	EdgeIterator tmp;
	tmp.ite = out_edges.begin();
	for(; tmp.ite!=out_edges.end() && (*(tmp.ite))->hidden == true; tmp.ite++);
	tmp.edge_list = &(out_edges);
	return tmp;
}

DiGraphNode::EdgeIterator DiGraphNode::OutEdgeEnd() {
	
	EdgeIterator tmp;
	tmp.ite = out_edges.end();
	tmp.edge_list = &(out_edges);
	return tmp;

}
