#ifndef __DINODE_HEADER_
#define __DINODE_HEADER_
#include "node.h"
//============================================================================
// DiGraphNode
// ===========
// Implements a node in a directed graph, subclass of the generic Node class
// Each DiGraphNode is associated with lists of incoming and outgoing edges of
// the node
//
// Constructors
// ------------
// DiGraphNode() 
// creates a directed graph node with empty in_edge and out_edge list
// Destructors
// -----------
// ~DiGrahNode()
//
// Functions
// ---------
// EdgeIterator InEdgeBegin(), InEdgeEnd
// returns the iterator referencing the begin and end of in_edge list
//
// EdgeIterator OutEdgeBegin(), OutEdgeEnd
// returns the iterator referencing the begin and end of out_edge lists
//
// DiGraph::EdgeIterator
// =====================
// Iterator class, iterates through edge list in a node of directed graph
//
// 
// Constructors/Destructors
// ------------------------
// none
//
// Overloaded operators
// --------------------
// ++ () prefix
// increments the iterator, points to next edge in the corresponding edge list
// order of the traverse is not specificied
// 
// = (const EdgeIterator& edge_ite)
// assigns edge_ite to current iterator
//
// ==, /= (const EdgeIterator& edge_ite)
// test for equality/inequality of two EdgeIterators
//
// *()
// dereference the iterator, returns the pointer to the referenced edge
// (DiGraphNode *)
//
//============================================================================


//============================================================================
// macros
//============================================================================

#define for_all_in_edges(edge_ite, n) \
    for(edge_ite=(n)->InEdgeBegin(); edge_ite!=(n)->InEdgeEnd(); ++edge_ite)
#define for_all_out_edges(edge_ite, n) \
    for(edge_ite=(n)->OutEdgeBegin(); edge_ite!=(n)->OutEdgeEnd(); ++edge_ite)


class DiGraphEdge;
class DiGraphNode : public Node {

   template<class NodeInfoType, class EdgeInfoType> friend class DiGraph;
    private:
        EdgeList in_edges;
        EdgeList out_edges;

    public:
        
        class EdgeIterator {
            template<class NodeInfoType, class EdgeInfoType> friend class DiGraph;
            friend class DiGraphNode;
            protected:
                //current position
                EdgeList::iterator ite;
                //points to the EdgeList being iterated
                EdgeList * edge_list;
            public:
                EdgeIterator& operator ++();
                bool operator ==(const EdgeIterator& edge_ite );
                bool operator !=(const EdgeIterator& edge_ite );
                DiGraphEdge * operator *();
                EdgeIterator &operator =(const EdgeIterator & edge_ite);
        };

        DiGraphNode();
        ~DiGraphNode();

        EdgeIterator InEdgeBegin();
        EdgeIterator InEdgeEnd();

        EdgeIterator OutEdgeBegin();
        EdgeIterator OutEdgeEnd();
};

#endif
