#include "directed_graph.h"
//============================================================================
// DiGraph::NodeIterator Implementation
//============================================================================


template<class NodeInfoType, class EdgeInfoType>
typename DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator & 
DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator++() {

    //boundary check is expected to be implemented by user
	ite++;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
typename DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator & 
DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator=(const DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator& node_ite) {

	ite = node_ite.ite;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
bool 
DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator==(const DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator& node_ite) {

	return (ite == node_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType>
bool 
DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator!=(const DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator& node_ite) {

	return (ite != node_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType> 
DiGraphNode *
DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator *() {

	return (DiGraphNode *) ((*ite).first);

}

//============================================================================
// DiGraph::EdgeIterator Implementation
//============================================================================


template<class NodeInfoType, class EdgeInfoType>
typename DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator & 
DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator++() {

	ite++;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
typename DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator & 
DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator=(const DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator& edge_ite) {

	ite = edge_ite.ite;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
bool 
DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator==(const DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator& edge_ite) {

	return (ite == edge_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType>
bool 
DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator!=(const DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator& edge_ite) {

	return (ite != edge_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType> 
DiGraphEdge *
DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator *() {

	return (DiGraphEdge *) ((*ite).first);

}

//============================================================================
// DiGraph Implementation
//============================================================================

template<class NodeInfoType, class EdgeInfoType> 
DiGraph<NodeInfoType, EdgeInfoType>::DiGraph() {


}
template<class NodeInfoType, class EdgeInfoType> 
DiGraph<NodeInfoType, EdgeInfoType>::~DiGraph() {

    emap_iterator ite;
	for(ite= EdgeInfoTypeMap.begin(); ite != EdgeInfoTypeMap.end(); ite++) {

        //since the generic Node * -> NodeInfoType * mapping is used
        //and we store DiGraphNode (a subclass of Node)
        //first memeber of ite is casted to DiGraphEdge * so that the
        //correct destructor is called
		delete ((DiGraphEdge *) ((*ite).first));
		delete ((*ite).second);
	}
	nmap_iterator ite2;
	for(ite2= NodeInfoTypeMap.begin(); ite2 != NodeInfoTypeMap.end(); ite2++) {
		delete ((DiGraphNode *) ((*ite2).first));
		delete ((*ite2).second);
	}

}

template<class NodeInfoType, class EdgeInfoType> 
DiGraphNode *
DiGraph<NodeInfoType, EdgeInfoType>::new_node(const NodeInfoType &node_info) {

	DiGraphNode * tmp = new DiGraphNode();
	NodeInfoType * info = new NodeInfoType();
	*info = node_info;
	//map stores a "pair" of type nmap_value_type
	//the pair contains members 'first' and 'second'
	//with first being the key and second being value
	insert_node_ret_val v = NodeInfoTypeMap.insert(nmap_value_type(tmp, info));

	// v.first = iterator of the inserted element, v.second = boolean indicating if 
	// insert is successful
	if(v.second == false)
		return NULL;
	
	return tmp;

}

template<class NodeInfoType, class EdgeInfoType> 
DiGraphEdge * 
DiGraph<NodeInfoType, EdgeInfoType>::new_edge(DiGraphNode * target, 
                                  DiGraphNode * source, const EdgeInfoType & edge_info) {

	
	DiGraphEdge * tmp = new DiGraphEdge();
	tmp->source = source;
	tmp->target = target;
	tmp->hidden = false;

	EdgeInfoType * info = new EdgeInfoType();
	*info = edge_info;
	//append this new edge to the edge lists of source and target
	target->in_edges.push_back(tmp);
	source->out_edges.push_back(tmp);

	//set the edge info
	
	insert_edge_ret_val v = EdgeInfoTypeMap.insert(emap_value_type(tmp, info));

	if(v.second == false)
		return NULL;
	
	return tmp;

}

template<class NodeInfoType, class EdgeInfoType> 
typename DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator
DiGraph<NodeInfoType, EdgeInfoType>::NodeBegin() {
	
	node_ite tmp;
	tmp.ite = NodeInfoTypeMap.begin();
	return tmp;
	

}

template<class NodeInfoType, class EdgeInfoType> 
typename DiGraph<NodeInfoType, EdgeInfoType>::NodeIterator
DiGraph<NodeInfoType, EdgeInfoType>::NodeEnd() {
	
	node_ite tmp;
	tmp.ite = NodeInfoTypeMap.end();
	return tmp;
}

template<class NodeInfoType, class EdgeInfoType> 
typename DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator
DiGraph<NodeInfoType, EdgeInfoType>::EdgeBegin() {
	
	edge_ite tmp;
	tmp.ite = EdgeInfoTypeMap.begin();
	return tmp;
	

}

template<class NodeInfoType, class EdgeInfoType> 
typename DiGraph<NodeInfoType, EdgeInfoType>::EdgeIterator
DiGraph<NodeInfoType, EdgeInfoType>::EdgeEnd() {
	
	edge_ite tmp;
	tmp.ite = EdgeInfoTypeMap.end();
	return tmp;
}
