#include "graph.h"


//============================================================================
// Graph Implementation
//============================================================================


template<class NodeInfoType, class EdgeInfoType> 
Graph<NodeInfoType, EdgeInfoType>::Graph() {


}

template<class NodeInfoType, class EdgeInfoType> 
Graph<NodeInfoType, EdgeInfoType>::Graph(NodeInfoType &n_default, EdgeInfoType &e_default) {

    node_default = n_default;
    edge_default = e_default;

}


template<class NodeInfoType, class EdgeInfoType> 
Graph<NodeInfoType, EdgeInfoType>::~Graph() {

	//should be implemented by the subclasses
}

template<class NodeInfoType, class EdgeInfoType> 
void
Graph<NodeInfoType, EdgeInfoType>::hide_edge(Edge * e) {
	
	e->hidden=true;
}

template<class NodeInfoType, class EdgeInfoType> 
void
Graph<NodeInfoType, EdgeInfoType>::restore_edge(Edge * e) {
	
	e->hidden=false;
}

template<class NodeInfoType, class EdgeInfoType> 
NodeInfoType&
Graph<NodeInfoType, EdgeInfoType>::inf(Node * n) {
	
	nmap_iterator q = NodeInfoTypeMap.find(n);
	
	if(q == NodeInfoTypeMap.end())
		return node_default;
	return  *((*q).second);

}

template<class NodeInfoType, class EdgeInfoType> 
EdgeInfoType&
Graph<NodeInfoType, EdgeInfoType>::inf(Edge * e) {
	
	emap_iterator q = EdgeInfoTypeMap.find(e);
	
	if(q == EdgeInfoTypeMap.end())
		return edge_default;
	return  *((*q).second);

}

template<class NodeInfoType, class EdgeInfoType> 
map<Node *, NodeInfoType *> &
Graph<NodeInfoType, EdgeInfoType>::node_data() {
	
    return NodeInfoTypeMap;
}
