#ifndef __GRAPH_HEADER_
#define __GRAPH_HEADER_
#include <list>
#include <map>
#include <utility>
#include <iostream>
#include "node.h"
#include "edge.h"
using namespace std;

//============================================================================
// Graph
// =======
// Generic templated Graph class, provides a base class to build directed and 
// undirected graphs
// The graph is parameterized, i.e. each node (edge) is associated with a user
// defined data type, NodeInfoType (EdgeInfoType). Node and edge and their 
// assoicated data are stored in two mappings: NodeInfoTypeMap and 
// EdgeInfoTypeMap.
//
// Constructors
// ------------
// Graph()
// creates an empty graph
// 
// Destructors
// -----------
// ~DiGraph()
//
// Functions
// ---------
//
// NodeInfoType *inf(Node * n);
// returns the data associated with node n
// 
// EdgeInfoType *inf(Edge * e);
// returns the data associated with edge e  
// 
// void hide_edge (Edge * e);
// void restore_edge(Edge *e);
// Hide/restore an edge in the graph
//============================================================================

//============================================================================
// macros
//============================================================================
#define for_all_nodes(node_ite, graph) \
    for(node_ite=(graph).NodeBegin(); node_ite!=(graph).NodeEnd(); ++node_ite)
#define for_all_edges(edge_ite, graph) \
    for(edge_ite=(graph).EdgeBegin(); edge_ite!=(graph).EdgeEnd(); ++edge_ite)


template <class NodeInfoType, class EdgeInfoType>
class Graph {
    
    protected:
        map<Node *, NodeInfoType *> NodeInfoTypeMap;
        map<Edge *, EdgeInfoType *> EdgeInfoTypeMap;
        NodeInfoType node_default;
        EdgeInfoType edge_default;
    public:
	typedef typename std::map<Node *, NodeInfoType *>::iterator  nmap_iterator;
	typedef typename std::map<Edge *, EdgeInfoType *>::iterator  emap_iterator;
	typedef typename std::map<Node *, NodeInfoType *>::value_type nmap_value_type;
        typedef typename std::map<Edge *, EdgeInfoType *>::value_type emap_value_type;
    
        Graph();
        Graph(NodeInfoType &n_default, EdgeInfoType &e_default);
        virtual ~Graph();

        NodeInfoType &inf(Node * n);
        EdgeInfoType &inf(Edge * e);
        
        void hide_edge (Edge * e);
        void restore_edge(Edge *e);
        
        map<Node *, NodeInfoType *> & node_data();
};
#endif

