#ifndef __UEDGE_HEADER__
#define __UEDGE_HEADER__
#include "edge.h"
#include "unode.h"
//============================================================================
// UGraphEdge
// ===========
// Implements an edge in undirected graph, subclass of the generic Edge class
// Each UGraphEdge is defined by a pair of UGraphNodes  
//
// Constructors
// ------------
// UGraphEdge() 
// creates an edge with no source and target nodes specified
// Destructors
// -----------
// ~DiGrahNode()
// 
// Functions
// ---------
// UGraphNode * Node1() , Node2()
// returns the DiGraphNodes connected the edge
//
//============================================================================
#define NODE1(edge_pt) (edge_pt)->Node1()
#define NODE2(edge_pt) (edge_pt)->Node2()
#define OPPOSITE(node_pt, edge_pt) \
            (edge_pt)->opposite(node_pt)
class UGraphEdge : public Edge {

    template<class NodeInfoType, class EdgeInfoType> friend class UGraph;
    friend class UGraphNode::EdgeIterator;
    private:
        UGraphNode * node1;
        UGraphNode * node2;
    public:
        UGraphEdge();
        ~UGraphEdge();
        UGraphNode * opposite(UGraphNode * n);
        UGraphNode * Node1();
        UGraphNode * Node2();
};

#endif
