#include "undirected_graph.h"
//============================================================================
// UGraph::NodeIterator Implementation
//============================================================================


template<class NodeInfoType, class EdgeInfoType>
typename UGraph<NodeInfoType, EdgeInfoType>::NodeIterator & 
UGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator++() {

    //boundary check is expected to be implemented by user
	ite++;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
typename UGraph<NodeInfoType, EdgeInfoType>::NodeIterator & 
UGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator=(const UGraph<NodeInfoType, EdgeInfoType>::NodeIterator& node_ite) {

	ite = node_ite.ite;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
bool 
UGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator==(const UGraph<NodeInfoType, EdgeInfoType>::NodeIterator& node_ite) {

	return (ite == node_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType>
bool 
UGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator!=(const UGraph<NodeInfoType, EdgeInfoType>::NodeIterator& node_ite) {

	return (ite != node_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType> 
UGraphNode *
UGraph<NodeInfoType, EdgeInfoType>::NodeIterator::operator *() {

	return (UGraphNode *) ((*ite).first);

}

//============================================================================
// UGraph::EdgeIterator Implementation
//============================================================================


template<class NodeInfoType, class EdgeInfoType>
typename UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator & 
UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator++() {

	ite++;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
typename UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator & 
UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator=(const UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator& edge_ite) {

	ite = edge_ite.ite;
	return *this;
}

template<class NodeInfoType, class EdgeInfoType>
bool 
UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator==(const UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator& edge_ite) {

	return (ite == edge_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType>
bool 
UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator!=(const UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator& edge_ite) {

	return (ite != edge_ite.ite);
}

template<class NodeInfoType, class EdgeInfoType> 
UGraphEdge *
UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator::operator *() {

	return (UGraphEdge *) ((*ite).first);

}

//============================================================================
// UGraph Implementation
//============================================================================

template<class NodeInfoType, class EdgeInfoType> 
UGraph<NodeInfoType, EdgeInfoType>::UGraph() {


}
template<class NodeInfoType, class EdgeInfoType> 
UGraph<NodeInfoType, EdgeInfoType>::~UGraph() {

    emap_iterator ite;
	for(ite= EdgeInfoTypeMap.begin(); ite != EdgeInfoTypeMap.end(); ite++) {

        //since the generic Node * -> NodeInfoType * mapping is used
        //and we store UGraphNode (a subclass of Node)
        //first memeber of ite is casted to UGraphEdge * so that the
        //correct destructor is called
		delete ((UGraphEdge *) ((*ite).first));
		delete ((*ite).second);
	}
	nmap_iterator ite2;
	for(ite2= NodeInfoTypeMap.begin(); ite2 != NodeInfoTypeMap.end(); ite2++) {
		delete ((UGraphNode *) ((*ite2).first));
		delete ((*ite2).second);
	}

}

template<class NodeInfoType, class EdgeInfoType> 
UGraphNode *
UGraph<NodeInfoType, EdgeInfoType>::new_node(const NodeInfoType &node_info) {

	UGraphNode * tmp = new UGraphNode();
	NodeInfoType * info = new NodeInfoType();
	*info = node_info;
	//map stores a "pair" of type nmap_value_type
	//the pair contains members 'first' and 'second'
	//with first being the key and second being value
	insert_node_ret_val v = NodeInfoTypeMap.insert(nmap_value_type(tmp, info));

	// v.first = iterator of the inserted element, v.second = boolean indicating if 
	// insert is successful
	if(v.second == false)
		return NULL;
	
	return tmp;

}

template<class NodeInfoType, class EdgeInfoType> 
UGraphEdge * 
UGraph<NodeInfoType, EdgeInfoType>::new_edge(UGraphNode * node1, 
                                  UGraphNode * node2, const EdgeInfoType & edge_info) {

	
	UGraphEdge * tmp = new UGraphEdge();
	tmp->node2 = node2;
	tmp->node1 = node1;
	tmp->hidden = false;

	EdgeInfoType * info = new EdgeInfoType();
	*info = edge_info;
	//append this new edge to the edge lists of node2 and node1
	node1->adj_edges.push_back(tmp);
	node2->adj_edges.push_back(tmp);

	//set the edge info
	
	insert_edge_ret_val v = EdgeInfoTypeMap.insert(emap_value_type(tmp, info));

	if(v.second == false)
		return NULL;
	
	return tmp;

}

template<class NodeInfoType, class EdgeInfoType> 
typename UGraph<NodeInfoType, EdgeInfoType>::NodeIterator
UGraph<NodeInfoType, EdgeInfoType>::NodeBegin() {
	
	node_ite tmp;
	tmp.ite = NodeInfoTypeMap.begin();
	return tmp;
	

}

template<class NodeInfoType, class EdgeInfoType> 
typename UGraph<NodeInfoType, EdgeInfoType>::NodeIterator
UGraph<NodeInfoType, EdgeInfoType>::NodeEnd() {
	
	node_ite tmp;
	tmp.ite = NodeInfoTypeMap.end();
	return tmp;
}

template<class NodeInfoType, class EdgeInfoType> 
typename UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator
UGraph<NodeInfoType, EdgeInfoType>::EdgeBegin() {
	
	edge_ite tmp;
	tmp.ite = EdgeInfoTypeMap.begin();
	return tmp;
	

}

template<class NodeInfoType, class EdgeInfoType> 
typename UGraph<NodeInfoType, EdgeInfoType>::EdgeIterator
UGraph<NodeInfoType, EdgeInfoType>::EdgeEnd() {
	
	edge_ite tmp;
	tmp.ite = EdgeInfoTypeMap.end();
	return tmp;
}
