#include "unode.h"
#include "uedge.h"
#include <iostream>
//============================================================================
// UGraphNode::EdgeIterator Implementation
//============================================================================

UGraphNode::EdgeIterator &UGraphNode::EdgeIterator::operator++() {
		
	//get to the next non-hidden edge
	ite++;
	for(; ite!=edge_list->end() && (*ite)->hidden == true; ite++);
	
	return *this;
}

UGraphNode::EdgeIterator &UGraphNode::EdgeIterator::operator=(const UGraphNode::EdgeIterator& edge_ite) {
	
	ite = edge_ite.ite;
	edge_list = edge_ite.edge_list;
	return *this;
}

bool UGraphNode::EdgeIterator::operator==(const UGraphNode::EdgeIterator& edge_ite) {

	return (ite == edge_ite.ite);
}

bool UGraphNode::EdgeIterator::operator!=(const UGraphNode::EdgeIterator& edge_ite) {

	return (ite != edge_ite.ite);
}

UGraphEdge * UGraphNode::EdgeIterator::operator*() {

	return (UGraphEdge *) * ite;
}



//============================================================================
// UGraphNode Implementation
//============================================================================
UGraphNode::UGraphNode() {
}

UGraphNode::~UGraphNode() {

    //memory deallocation always done by the graph
    //nothing to be done here
}


UGraphNode::EdgeIterator UGraphNode::AdjEdgeBegin() {
	
	EdgeIterator tmp;
	tmp.ite = adj_edges.begin();
	//go to the first non hidden edge
	for(; tmp.ite!=adj_edges.end() && (*(tmp.ite))->hidden == true; tmp.ite++);
	
	//store the pointer to adj_edges in tmp
	tmp.edge_list = &(adj_edges);
	
	return tmp;
}

UGraphNode::EdgeIterator UGraphNode::AdjEdgeEnd() {
	
	EdgeIterator tmp;
	tmp.ite = adj_edges.end();

    //the edge_list should have been assigned by InEdgeBegin()
    //
	tmp.edge_list = &(adj_edges);
	return tmp;

}


