#ifndef __UNODE_HEADER_
#define __UNODE_HEADER_
#include "node.h"
//============================================================================
// UGraphNode
// ===========
// Implements a node in an undirected graph, subclass of the generic Node class
// Each UGraphNode is associated with a list of undirected edges (UGraphEdge)
// representing its neighbors in the graph
// the node
//
// Constructors
// ------------
// UGraphNode() 
// creates an undirected graph node with empty adj_edge list
// Destructors
// -----------
// ~UGrahNode()
//
// Functions
// ---------
// EdgeIterator AdjEdgeBegin(), AdjEdgeEnd
// returns the iterator referencing the begin and end of adj_edge list
//
// DiGraph::EdgeIterator
// =====================
// Iterator class, iterates through edge list in a node of directed graph
//
// Constructors/Destructors
// ------------------------
// none
//
// Overloaded operators
// --------------------
// ++ () prefix
// increments the iterator, points to next edge in the corresponding edge list
// order of the traverse is not specificied
// 
// = (const EdgeIterator& edge_ite)
// assigns edge_ite to current iterator
//
// ==, /= (const EdgeIterator& edge_ite)
// test for equality/inequality of two EdgeIterators
//
// *()
// dereference the iterator, returns the pointer to the referenced edge
// (UGraphNode *)
//
//============================================================================


//============================================================================
// macros
//============================================================================

#define for_all_adj_edges(edge_ite, n) \
    for(edge_ite=(n)->AdjEdgeBegin(); edge_ite!=(n)->AdjEdgeEnd(); ++edge_ite)


class UGraphEdge;
class UGraphNode : public Node {

   template<class NodeInfoType, class EdgeInfoType> friend class UGraph;
    private:
        EdgeList adj_edges;

    public:
        
        class EdgeIterator {
            template<class NodeInfoType, class EdgeInfoType> friend class UGraph;
            friend class UGraphNode;
            protected:
                //current position
                EdgeList::iterator ite;
                //points to the EdgeList being iterated
                EdgeList * edge_list;
            public:
                EdgeIterator& operator ++();
                bool operator ==(const EdgeIterator& edge_ite );
                bool operator !=(const EdgeIterator& edge_ite );
                UGraphEdge * operator *();
                EdgeIterator &operator =(const EdgeIterator & edge_ite);
        };

        UGraphNode();
        ~UGraphNode();

        EdgeIterator AdjEdgeBegin();
        EdgeIterator AdjEdgeEnd();
};

#endif
