/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.expirations.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.accounting.movements.java.JournalHeaderVO;
import org.jallinone.accounting.movements.java.JournalRowVO;
import org.jallinone.accounting.movements.server.InsertJournalItemBean;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.expirations.java.ExpirationVO;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.jallinone.system.server.LoadUserParamAction;
import org.openswing.swing.internationalization.java.Resources;
import org.openswing.swing.internationalization.server.ServerResourcesFactory;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.server.Action;
import org.openswing.swing.server.ConnectionManager;
import org.openswing.swing.server.QueryUtil;
import org.openswing.swing.server.UserSessionParameters;

public class UpdateExpirationsAction
implements Action {
    InsertJournalItemBean insJornalItemAction = new InsertJournalItemBean();
    LoadUserParamAction userParamAction = new LoadUserParamAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response executeCommand(Object inputPar, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            String serverLanguageId = ((JAIOUserSessionParameters)userSessionPars).getServerLanguageId();
            conn = ConnectionManager.getConnection((ServletContext)context);
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, null));
            ArrayList oldVOs = ((ArrayList[])inputPar)[0];
            ArrayList newVOs = ((ArrayList[])inputPar)[1];
            ExpirationVO oldVO = null;
            ExpirationVO newVO = null;
            Response res = null;
            HashSet<String> pkAttrs = new HashSet<String>();
            pkAttrs.add("companyCodeSys01DOC19");
            pkAttrs.add("progressiveDOC19");
            HashMap<String, String> attribute2dbField = new HashMap<String, String>();
            attribute2dbField.put("progressiveDOC19", "PROGRESSIVE");
            attribute2dbField.put("companyCodeSys01DOC19", "COMPANY_CODE_SYS01");
            attribute2dbField.put("docTypeDOC19", "DOC_TYPE");
            attribute2dbField.put("docNumberDOC19", "DOC_NUMBER");
            attribute2dbField.put("docYearDOC19", "DOC_YEAR");
            attribute2dbField.put("docSequenceDOC19", "DOC_SEQUENCE");
            attribute2dbField.put("name_1DOC19", "NAME_1");
            attribute2dbField.put("name_2DOC19", "NAME_2");
            attribute2dbField.put("descriptionDOC19", "DESCRIPTION");
            attribute2dbField.put("valueDOC19", "VALUE");
            attribute2dbField.put("payedDOC19", "PAYED");
            attribute2dbField.put("docDateDOC19", "DOC_DATE");
            attribute2dbField.put("expirationDateDOC19", "EXPIRATION_DATE");
            attribute2dbField.put("progressiveReg04DOC19", "PROGRESSIVE_REG04");
            attribute2dbField.put("customerSupplierCodeDOC19", "CUSTOMER_SUPPLIER_CODE");
            JournalHeaderVO jhVO = null;
            ServerResourcesFactory factory = (ServerResourcesFactory)context.getAttribute("RESOURCES_FACTORY");
            Resources resources = factory.getResources(userSessionPars.getLanguageId());
            HashMap<String, String> map = new HashMap<String, String>();
            String bankAccountCode = null;
            int i = 0;
            while (i < oldVOs.size()) {
                Response response2;
                oldVO = (ExpirationVO)((Object)oldVOs.get(i));
                newVO = (ExpirationVO)((Object)newVOs.get(i));
                new QueryUtil();
                res = QueryUtil.updateTable((Connection)conn, (UserSessionParameters)userSessionPars, pkAttrs, (ValueObject)oldVO, (ValueObject)newVO, (String)"DOC19_EXPIRATIONS", attribute2dbField, (String)"Y", (String)"N", (ServletContext)context, (boolean)true);
                if (res.isError()) {
                    conn.rollback();
                    response2 = res;
                    return response2;
                }
                map.put("COMPANY_CODE_SYS01", newVO.getCompanyCodeSys01DOC19());
                map.put("PARAM_CODE", "BANK_ACCOUNT");
                res = this.userParamAction.executeCommand(map, userSessionPars, request, response, userSession, context);
                if (res.isError()) {
                    conn.rollback();
                    response2 = res;
                    return response2;
                }
                bankAccountCode = ((VOResponse)res).getVo().toString();
                if (!oldVO.getPayedDOC19().booleanValue() && newVO.getPayedDOC19().booleanValue()) {
                    ResultSet rset;
                    jhVO = new JournalHeaderVO();
                    jhVO.setCompanyCodeSys01ACC05(newVO.getCompanyCodeSys01DOC19());
                    String creditDebitAccountCode = null;
                    String accountCodeTypeACC06 = null;
                    if (newVO.getDocTypeDOC19().equals("I") || newVO.getDocTypeDOC19().equals("N") || newVO.getDocTypeDOC19().equals("S") || newVO.getDocTypeDOC19().equals("R") || newVO.getDocTypeDOC19().equals("A")) {
                        jhVO.setAccountingMotiveCodeAcc03ACC05("110");
                        jhVO.setDescriptionACC05(newVO.getDescriptionDOC19() + " - " + resources.getResource("customer") + " " + newVO.getName_1DOC19() + " " + (newVO.getName_2DOC19() == null ? "" : newVO.getName_2DOC19()));
                        pstmt = conn.prepareStatement("select CREDIT_ACCOUNT_CODE_ACC02 from SAL07_CUSTOMERS where COMPANY_CODE_SYS01=? and PROGRESSIVE_REG04=?");
                        pstmt.setString(1, newVO.getCompanyCodeSys01DOC19());
                        pstmt.setBigDecimal(2, newVO.getProgressiveReg04DOC19());
                        rset = pstmt.executeQuery();
                        if (!rset.next()) {
                            rset.close();
                            ErrorResponse errorResponse = new ErrorResponse("customer not found");
                            return errorResponse;
                        }
                        creditDebitAccountCode = rset.getString(1);
                        rset.close();
                        pstmt.close();
                        accountCodeTypeACC06 = "C";
                    } else {
                        jhVO.setAccountingMotiveCodeAcc03ACC05("120");
                        jhVO.setDescriptionACC05(newVO.getDescriptionDOC19() + " - " + resources.getResource("supplier") + " " + newVO.getName_1DOC19() + " " + (newVO.getName_2DOC19() == null ? "" : newVO.getName_2DOC19()));
                        pstmt = conn.prepareStatement("select DEBIT_ACCOUNT_CODE_ACC02 from PUR01_SUPPLIERS where COMPANY_CODE_SYS01=? and PROGRESSIVE_REG04=?");
                        pstmt.setString(1, newVO.getCompanyCodeSys01DOC19());
                        pstmt.setBigDecimal(2, newVO.getProgressiveReg04DOC19());
                        rset = pstmt.executeQuery();
                        if (!rset.next()) {
                            rset.close();
                            ErrorResponse errorResponse = new ErrorResponse("supplier not found");
                            return errorResponse;
                        }
                        creditDebitAccountCode = rset.getString(1);
                        rset.close();
                        pstmt.close();
                        accountCodeTypeACC06 = "S";
                    }
                    jhVO.setItemDateACC05(new Date(System.currentTimeMillis()));
                    jhVO.setItemYearACC05(new BigDecimal((double)Calendar.getInstance().get(1)));
                    JournalRowVO jrVO = new JournalRowVO();
                    jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
                    jrVO.setAccountCodeAcc02ACC06(creditDebitAccountCode);
                    jrVO.setAccountCodeACC06(newVO.getCustomerSupplierCodeDOC19());
                    jrVO.setAccountCodeTypeACC06(accountCodeTypeACC06);
                    jrVO.setCreditAmountACC06(newVO.getValueDOC19());
                    jrVO.setDescriptionACC06("");
                    jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
                    jrVO.setProgressiveAcc05ACC06(jhVO.getProgressiveACC05());
                    jhVO.addJournalRow(jrVO);
                    jrVO = new JournalRowVO();
                    jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
                    jrVO.setAccountCodeAcc02ACC06(bankAccountCode);
                    jrVO.setAccountCodeACC06(bankAccountCode);
                    jrVO.setAccountCodeTypeACC06("A");
                    jrVO.setDebitAmountACC06(newVO.getValueDOC19());
                    jrVO.setDescriptionACC06("");
                    jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
                    jrVO.setProgressiveAcc05ACC06(jhVO.getProgressiveACC05());
                    jhVO.addJournalRow(jrVO);
                    res = this.insJornalItemAction.insertItem(conn, jhVO, userSessionPars, request, response, userSession, context);
                    if (res.isError()) {
                        conn.rollback();
                        Response response3 = res;
                        return response3;
                    }
                }
                ++i;
            }
            VOListResponse answer = new VOListResponse((List)newVOs, false, newVOs.size());
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 1, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
            conn.commit();
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 2, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
            VOListResponse vOListResponse = answer;
            return vOListResponse;
        }
        catch (Throwable ex) {
            Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"executeCommand", (String)"Error while updating existing expirations", (Throwable)ex);
            try {
                conn.rollback();
            }
            catch (Exception ex3) {
                // empty catch block
            }
            ErrorResponse errorResponse = new ErrorResponse(ex.getMessage());
            return errorResponse;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex1) {}
            try {
                ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
            }
            catch (Exception ex1) {
            }
        }
    }

    public final String getRequestName() {
        return "updateExpirations";
    }
}

