/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.production.orders.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.jallinone.items.java.ItemPK;
import org.jallinone.production.billsofmaterial.java.AltComponentVO;
import org.jallinone.production.billsofmaterial.java.MaterialVO;
import org.jallinone.production.billsofmaterial.server.LoadAltComponentsAction;
import org.jallinone.production.billsofmaterial.server.LoadBillOfMaterialBean;
import org.jallinone.production.orders.java.ProdOrderComponentVO;
import org.jallinone.production.orders.java.ProdOrderProductVO;
import org.jallinone.registers.measure.server.MeasureConvBean;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.jallinone.warehouse.availability.java.ItemAvailabilityVO;
import org.jallinone.warehouse.availability.server.LoadItemAvailabilitiesAction;
import org.openswing.swing.internationalization.java.Resources;
import org.openswing.swing.internationalization.server.ServerResourcesFactory;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.server.UserSessionParameters;

public class CheckComponentsAvailabilityBean {
    private LoadAltComponentsAction altComps;
    private LoadItemAvailabilitiesAction avail;
    private LoadBillOfMaterialBean bean = new LoadBillOfMaterialBean();
    private MeasureConvBean conv;

    public CheckComponentsAvailabilityBean() {
        this.avail = new LoadItemAvailabilitiesAction();
        this.altComps = new LoadAltComponentsAction();
        this.conv = new MeasureConvBean();
    }

    public final Response checkComponentsAvailability(Connection conn, Hashtable compAltComps, ArrayList products, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        String serverLanguageId = ((JAIOUserSessionParameters)userSessionPars).getServerLanguageId();
        try {
            ArrayList<Object> list;
            ServerResourcesFactory factory = (ServerResourcesFactory)context.getAttribute("RESOURCES_FACTORY");
            Resources resources = factory.getResources(userSessionPars.getLanguageId());
            if (products.size() == 0) {
                return new VOListResponse(new ArrayList(), false, 0);
            }
            ItemPK pk = null;
            ProdOrderProductVO prodVO = null;
            ArrayList components = null;
            MaterialVO compVO = null;
            Response res = null;
            ProdOrderComponentVO componentVO = null;
            Hashtable<String, ProdOrderComponentVO> comps = new Hashtable<String, ProdOrderComponentVO>();
            int i = 0;
            while (i < products.size()) {
                prodVO = (ProdOrderProductVO)((Object)products.get(i));
                pk = new ItemPK(prodVO.getCompanyCodeSys01DOC23(), prodVO.getItemCodeItm01DOC23());
                res = this.bean.getBillOfMaterials(conn, pk, userSessionPars, request, response, userSession, context);
                if (res.isError()) {
                    return res;
                }
                components = this.getComponents((DefaultMutableTreeNode)((TreeModel)((VOResponse)res).getVo()).getRoot());
                int j = 0;
                while (j < components.size()) {
                    compVO = (MaterialVO)((Object)components.get(j));
                    componentVO = (ProdOrderComponentVO)((Object)comps.get(compVO.getItemCodeItm01ITM03()));
                    if (componentVO == null) {
                        componentVO = new ProdOrderComponentVO();
                        comps.put(compVO.getItemCodeItm01ITM03(), componentVO);
                        componentVO.setAvailableQty(new BigDecimal(0.0));
                        componentVO.setCompanyCodeSys01DOC24(compVO.getCompanyCodeSys01ITM03());
                        componentVO.setDescriptionSYS10(compVO.getDescriptionSYS10());
                        componentVO.setDocNumberDOC24(prodVO.getDocNumberDOC23());
                        componentVO.setDocYearDOC24(prodVO.getDocYearDOC23());
                        componentVO.setItemCodeItm01DOC24(compVO.getItemCodeItm01ITM03());
                        componentVO.setMinSellingQtyUmCodeReg02ITM01(compVO.getMinSellingQtyUmCodeReg02ITM01());
                        componentVO.setQtyDOC24(new BigDecimal(0.0));
                    }
                    componentVO.setQtyDOC24(componentVO.getQtyDOC24().add(compVO.getQtyITM03().multiply(prodVO.getQtyDOC23())));
                    ++j;
                }
                ++i;
            }
            Enumeration en = comps.keys();
            GridParams gridParams = new GridParams();
            gridParams.getOtherGridParams().put("COMPANY_CODE_SYS01", prodVO.getCompanyCodeSys01DOC23());
            gridParams.getOtherGridParams().put("WAREHOUSE_CODE", prodVO.getWarehouseCodeWar01DOC22());
            gridParams.getOtherGridParams().put("LOAD_ALL", Boolean.TRUE);
            ItemAvailabilityVO availVO = null;
            String itemCode = null;
            AltComponentVO altVO = null;
            ArrayList<ProdOrderComponentVO> alternativeComps = new ArrayList<ProdOrderComponentVO>();
            ArrayList<ProdOrderComponentVO> compsToRemove = new ArrayList<ProdOrderComponentVO>();
            ProdOrderComponentVO altComponentVO = null;
            HashSet<String> altCodes = null;
            BigDecimal altQty = null;
            block4: while (en.hasMoreElements()) {
                itemCode = en.nextElement().toString();
                componentVO = (ProdOrderComponentVO)((Object)comps.get(itemCode));
                gridParams.getOtherGridParams().put("ITEM_PK", new ItemPK(prodVO.getCompanyCodeSys01DOC23(), itemCode));
                res = this.avail.executeCommand(gridParams, userSessionPars, request, response, userSession, context);
                if (res.isError()) {
                    return res;
                }
                ArrayList availList = new ArrayList(((VOListResponse)res).getRows());
                componentVO.setAvailabilities(availList);
                BigDecimal availability = new BigDecimal(0.0);
                int i2 = 0;
                while (i2 < availList.size()) {
                    availVO = (ItemAvailabilityVO)((Object)availList.get(i2));
                    availability = availability.add(availVO.getAvailableQtyWAR03());
                    ++i2;
                }
                componentVO.setAvailableQty(availability);
                if (!(componentVO.getQtyDOC24().doubleValue() > componentVO.getAvailableQty().doubleValue())) continue;
                res = this.altComps.executeCommand(gridParams, userSessionPars, request, response, userSession, context);
                if (res.isError()) {
                    return res;
                }
                list = new ArrayList(((VOListResponse)res).getRows());
                int i3 = 0;
                while (i3 < list.size()) {
                    altVO = (AltComponentVO)((Object)list.get(i3));
                    gridParams.getOtherGridParams().put("ITEM_PK", new ItemPK(prodVO.getCompanyCodeSys01DOC23(), altVO.getItemCodeItm01ITM04()));
                    res = this.avail.executeCommand(gridParams, userSessionPars, request, response, userSession, context);
                    if (res.isError()) {
                        return res;
                    }
                    availList = new ArrayList(((VOListResponse)res).getRows());
                    BigDecimal altAvailability = new BigDecimal(0.0);
                    int j = 0;
                    while (j < availList.size()) {
                        availVO = (ItemAvailabilityVO)((Object)availList.get(j));
                        altAvailability = altAvailability.add(availVO.getAvailableQtyWAR03());
                        ++j;
                    }
                    if (altAvailability.doubleValue() > 0.0) {
                        BigDecimal delta;
                        altComponentVO = new ProdOrderComponentVO();
                        altComponentVO.setAvailabilities(availList);
                        altComponentVO.setAvailableQty(altAvailability);
                        altComponentVO.setCompanyCodeSys01DOC24(altVO.getCompanyCodeSys01ITM04());
                        altComponentVO.setDescriptionSYS10(altVO.getDescriptionSYS10());
                        altComponentVO.setDocNumberDOC24(prodVO.getDocNumberDOC23());
                        altComponentVO.setDocYearDOC24(prodVO.getDocYearDOC23());
                        altComponentVO.setItemCodeItm01DOC24(altVO.getItemCodeItm01ITM04());
                        altComponentVO.setMinSellingQtyUmCodeReg02ITM01(altVO.getMinSellingQtyUmCodeReg02ITM01());
                        altQty = this.conv.convertQty(altVO.getMinSellingQtyUmCodeReg02ITM01(), componentVO.getMinSellingQtyUmCodeReg02ITM01(), altAvailability, userSessionPars, request, response, userSession, context);
                        if (componentVO.getQtyDOC24().subtract(availability).doubleValue() > altQty.doubleValue()) {
                            delta = altQty;
                            altComponentVO.setQtyDOC24(altAvailability);
                        } else {
                            delta = componentVO.getQtyDOC24();
                            altComponentVO.setQtyDOC24(this.conv.convertQty(componentVO.getMinSellingQtyUmCodeReg02ITM01(), altVO.getMinSellingQtyUmCodeReg02ITM01(), delta, userSessionPars, request, response, userSession, context));
                        }
                        componentVO.setQtyDOC24(componentVO.getQtyDOC24().subtract(delta));
                        alternativeComps.add(altComponentVO);
                        altCodes = (HashSet<String>)compAltComps.get(itemCode);
                        if (altCodes == null) {
                            altCodes = new HashSet<String>();
                            compAltComps.put(itemCode, altCodes);
                        }
                        altCodes.add(altVO.getItemCodeItm01ITM04());
                        if (componentVO.getQtyDOC24().doubleValue() == 0.0) {
                            compsToRemove.add(componentVO);
                            continue block4;
                        }
                        if (componentVO.getQtyDOC24().subtract(availability).doubleValue() == 0.0) continue block4;
                    }
                    ++i3;
                }
            }
            list = new ArrayList(comps.values());
            list.addAll(alternativeComps);
            list.removeAll(compsToRemove);
            return new VOListResponse(list, false, list.size());
        }
        catch (Throwable ex) {
            Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"checkComponentsAvailability", (String)"Error while retrieving components availability for the specified production order", (Throwable)ex);
            return new ErrorResponse(ex.getMessage());
        }
    }

    private ArrayList getComponents(DefaultMutableTreeNode node) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < node.getChildCount()) {
            list.addAll(this.getComponents((DefaultMutableTreeNode)node.getChildAt(i)));
            ++i;
        }
        if (node.isLeaf()) {
            list.add(node.getUserObject());
        }
        return list;
    }
}

