/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.documents.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.accounting.movements.java.TaxableIncomeVO;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.purchases.documents.java.DetailPurchaseDocVO;
import org.jallinone.purchases.documents.server.LoadPurchaseDocAction;
import org.jallinone.registers.vat.server.ValidateVatCodeAction;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.server.UserSessionParameters;

public class PurchaseDocTaxableIncomesBean {
    private LoadPurchaseDocAction docAction;
    private ValidateVatCodeAction vatBean = new ValidateVatCodeAction();

    public PurchaseDocTaxableIncomesBean() {
        this.docAction = new LoadPurchaseDocAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final Response calcTaxableIncomes(Connection conn, DetailPurchaseDocVO vo, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        Enumeration en;
        Enumeration en2;
        Statement pstmt = null;
        EventsManager.getInstance().processEvent(new GenericEvent(this, "PurchaseDocTaxableIncomesBean.calcTaxableIncomes", 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, (Object)vo, null));
        Hashtable<String, TaxableIncomeVO> itemsTaxableIncomes = new Hashtable<String, TaxableIncomeVO>();
        TaxableIncomeVO tVO = null;
        BigDecimal totalRowsVat = new BigDecimal(0.0);
        BigDecimal totalRowsTaxableIncome = new BigDecimal(0.0);
        ArrayList<BigDecimal> rowsTaxableIncome = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> rowsVatValue = new ArrayList<BigDecimal>();
        pstmt = conn.prepareStatement("select VAT_VALUE,TAXABLE_INCOME,VALUE_REG01,DEDUCTIBLE_REG01,VAT_CODE_ITM01,VAT_DESCRIPTION from DOC07_PURCHASE_ITEMS where COMPANY_CODE_SYS01=? and DOC_TYPE=? and DOC_YEAR=? and DOC_NUMBER=?");
        pstmt.setString(1, vo.getCompanyCodeSys01DOC06());
        pstmt.setString(2, vo.getDocTypeDOC06());
        pstmt.setBigDecimal(3, vo.getDocYearDOC06());
        pstmt.setBigDecimal(4, vo.getDocNumberDOC06());
        ResultSet rset = pstmt.executeQuery();
        while (rset.next()) {
            totalRowsVat = totalRowsVat.add(rset.getBigDecimal(1));
            totalRowsTaxableIncome = totalRowsTaxableIncome.add(rset.getBigDecimal(2));
            rowsTaxableIncome.add(rset.getBigDecimal(2));
            rowsVatValue.add(new BigDecimal(rset.getDouble(3) * (1.0 - rset.getDouble(4) / 100.0)));
            tVO = (TaxableIncomeVO)((Object)itemsTaxableIncomes.get(rset.getString(5)));
            if (tVO == null) {
                tVO = new TaxableIncomeVO();
                tVO.setRowType(0);
                tVO.setVatCode(rset.getString(5));
                tVO.setVatDescription(rset.getString(6));
                tVO.setTaxableIncome(rset.getBigDecimal(2).setScale(vo.getDecimalsREG03().intValue(), 4));
                tVO.setVatValue(rset.getBigDecimal(1).setScale(vo.getDecimalsREG03().intValue(), 4));
            } else {
                tVO.setTaxableIncome(tVO.getTaxableIncome().add(rset.getBigDecimal(2).setScale(vo.getDecimalsREG03().intValue(), 4)));
                tVO.setVatValue(tVO.getVatValue().add(rset.getBigDecimal(1).setScale(vo.getDecimalsREG03().intValue(), 4)));
            }
            itemsTaxableIncomes.put(rset.getString(5), tVO);
        }
        rset.close();
        BigDecimal totalDocVat = totalRowsVat;
        BigDecimal totalDocTaxableIncome = totalRowsTaxableIncome;
        double discTaxableIncome = 0.0;
        double discVatValue = 0.0;
        double discTotalTaxableIncome = 0.0;
        double discTotalVatValue = 0.0;
        if (vo.getDiscountPercDOC06() != null) {
            en2 = itemsTaxableIncomes.keys();
            while (en2.hasMoreElements()) {
                tVO = (TaxableIncomeVO)((Object)itemsTaxableIncomes.get(en2.nextElement()));
                discTaxableIncome = tVO.getTaxableIncome().doubleValue() * vo.getDiscountPercDOC06().doubleValue() / 100.0;
                discVatValue = discTaxableIncome * tVO.getVatValue().doubleValue() / tVO.getTaxableIncome().doubleValue();
                tVO.setTaxableIncome(tVO.getTaxableIncome().subtract(new BigDecimal(discTaxableIncome).setScale(vo.getDecimalsREG03().intValue(), 4)));
                tVO.setVatValue(tVO.getVatValue().subtract(new BigDecimal(discVatValue).setScale(vo.getDecimalsREG03().intValue(), 4)));
            }
        }
        if (vo.getDiscountValueDOC06() != null) {
            en2 = itemsTaxableIncomes.keys();
            while (en2.hasMoreElements()) {
                tVO = (TaxableIncomeVO)((Object)itemsTaxableIncomes.get(en2.nextElement()));
                discTaxableIncome = tVO.getTaxableIncome().doubleValue() / totalRowsTaxableIncome.doubleValue() * vo.getDiscountValueDOC06().doubleValue();
                discVatValue = discTaxableIncome * tVO.getVatValue().doubleValue() / tVO.getTaxableIncome().doubleValue();
                tVO.setTaxableIncome(tVO.getTaxableIncome().subtract(new BigDecimal(discTaxableIncome).setScale(vo.getDecimalsREG03().intValue(), 4)));
                tVO.setVatValue(tVO.getVatValue().subtract(new BigDecimal(discVatValue).setScale(vo.getDecimalsREG03().intValue(), 4)));
            }
        }
        double chargeTaxableIncome = 0.0;
        double chargeVatValue = 0.0;
        double chargeTotalTaxableIncome = 0.0;
        double chargeTotalVatValue = 0.0;
        if (vo.getChargeValueDOC06() != null) {
            en = itemsTaxableIncomes.keys();
            while (en.hasMoreElements()) {
                tVO = (TaxableIncomeVO)((Object)itemsTaxableIncomes.get(en.nextElement()));
                chargeTaxableIncome = tVO.getTaxableIncome().doubleValue() / totalRowsTaxableIncome.doubleValue() * vo.getChargeValueDOC06().doubleValue();
                chargeVatValue = chargeTaxableIncome * tVO.getVatValue().doubleValue() / tVO.getTaxableIncome().doubleValue();
                tVO.setTaxableIncome(tVO.getTaxableIncome().add(new BigDecimal(chargeTaxableIncome).setScale(vo.getDecimalsREG03().intValue(), 4)));
                tVO.setVatValue(tVO.getVatValue().add(new BigDecimal(chargeVatValue).setScale(vo.getDecimalsREG03().intValue(), 4)));
            }
        }
        if (vo.getChargePercDOC06() != null && vo.getChargePercDOC06().intValue() > 0) {
            en = itemsTaxableIncomes.keys();
            while (en.hasMoreElements()) {
                tVO = (TaxableIncomeVO)((Object)itemsTaxableIncomes.get(en.nextElement()));
                chargeTaxableIncome = tVO.getTaxableIncome().doubleValue() * vo.getChargePercDOC06().doubleValue() / 100.0;
                chargeVatValue = chargeTaxableIncome * tVO.getVatValue().doubleValue() / tVO.getTaxableIncome().doubleValue();
                tVO.setTaxableIncome(tVO.getTaxableIncome().add(new BigDecimal(chargeTaxableIncome).setScale(vo.getDecimalsREG03().intValue(), 4)));
                tVO.setVatValue(tVO.getVatValue().add(new BigDecimal(chargeVatValue).setScale(vo.getDecimalsREG03().intValue(), 4)));
            }
        }
        ArrayList taxableIncomeRows = new ArrayList();
        Enumeration en3 = itemsTaxableIncomes.keys();
        while (en3.hasMoreElements()) {
            taxableIncomeRows.add(itemsTaxableIncomes.get(en3.nextElement()));
        }
        VOListResponse answer = new VOListResponse(taxableIncomeRows, false, taxableIncomeRows.size());
        EventsManager.getInstance().processEvent(new GenericEvent(this, "PurchaseDocTaxableIncomesBean.calcTaxableIncomes", 1, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, (Object)vo, answer));
        VOListResponse vOListResponse = answer;
        Object var39_33 = null;
        try {
            pstmt.close();
        }
        catch (Exception ex2) {
        }
        return vOListResponse;
        catch (Throwable ex) {
            ErrorResponse errorResponse;
            try {
                Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"calcTaxableIncomes", (String)"Error on calculating ourchase document taxable incomes", (Throwable)ex);
                errorResponse = new ErrorResponse(ex.getMessage());
                Object var39_34 = null;
            }
            catch (Throwable throwable) {
                Object var39_35 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
            try {
                pstmt.close();
            }
            catch (Exception ex2) {
            }
            return errorResponse;
        }
    }
}

