/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.documents.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.purchases.documents.java.DetailPurchaseDocVO;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.server.UserSessionParameters;

public class PurchaseDocTotalsBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final Response calcDocTotals(Connection conn, DetailPurchaseDocVO vo, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        int i;
        Statement pstmt = null;
        EventsManager.getInstance().processEvent(new GenericEvent(this, "PurchaseDocTotalsBean.calcDocTotals", 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, (Object)vo, null));
        BigDecimal totalRowsVat = new BigDecimal(0.0);
        BigDecimal totalRowsTaxableIncome = new BigDecimal(0.0);
        ArrayList<BigDecimal> rowsTaxableIncome = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> rowsVatValue = new ArrayList<BigDecimal>();
        pstmt = conn.prepareStatement("select VAT_VALUE,TAXABLE_INCOME,VALUE_REG01,DEDUCTIBLE_REG01 from DOC07_PURCHASE_ITEMS where COMPANY_CODE_SYS01=? and DOC_TYPE=? and DOC_YEAR=? and DOC_NUMBER=?");
        pstmt.setString(1, vo.getCompanyCodeSys01DOC06());
        pstmt.setString(2, vo.getDocTypeDOC06());
        pstmt.setBigDecimal(3, vo.getDocYearDOC06());
        pstmt.setBigDecimal(4, vo.getDocNumberDOC06());
        ResultSet rset = pstmt.executeQuery();
        while (rset.next()) {
            totalRowsVat = totalRowsVat.add(rset.getBigDecimal(1));
            totalRowsTaxableIncome = totalRowsTaxableIncome.add(rset.getBigDecimal(2));
            rowsTaxableIncome.add(rset.getBigDecimal(2));
            rowsVatValue.add(new BigDecimal(rset.getDouble(3) * (1.0 - rset.getDouble(4) / 100.0)));
        }
        rset.close();
        BigDecimal totalDocVat = totalRowsVat;
        BigDecimal totalDocTaxableIncome = totalRowsTaxableIncome;
        double discTaxableIncome = 0.0;
        double discVatValue = 0.0;
        double discTotalTaxableIncome = 0.0;
        double discTotalVatValue = 0.0;
        if (vo.getDiscountPercDOC06() != null) {
            i = 0;
            while (i < rowsTaxableIncome.size()) {
                discTaxableIncome = ((BigDecimal)rowsTaxableIncome.get(i)).doubleValue() * vo.getDiscountPercDOC06().doubleValue() / 100.0;
                discVatValue = discTaxableIncome * ((BigDecimal)rowsVatValue.get(i)).doubleValue() / 100.0;
                discTotalTaxableIncome += discTaxableIncome;
                discTotalVatValue += discVatValue;
                rowsTaxableIncome.set(i, new BigDecimal(((BigDecimal)rowsTaxableIncome.get(i)).doubleValue() - discTaxableIncome));
                ++i;
            }
            totalRowsVat = new BigDecimal(totalRowsVat.doubleValue() - totalRowsVat.doubleValue() * vo.getDiscountPercDOC06().doubleValue() / 100.0);
            totalRowsTaxableIncome = new BigDecimal(totalRowsTaxableIncome.doubleValue() - totalRowsTaxableIncome.doubleValue() * vo.getDiscountPercDOC06().doubleValue() / 100.0);
        }
        if (vo.getDiscountValueDOC06() != null) {
            i = 0;
            while (i < rowsTaxableIncome.size()) {
                discTaxableIncome = ((BigDecimal)rowsTaxableIncome.get(i)).doubleValue() / totalRowsTaxableIncome.doubleValue() * vo.getDiscountValueDOC06().doubleValue();
                discVatValue = discTaxableIncome * ((BigDecimal)rowsVatValue.get(i)).doubleValue() / 100.0;
                discTotalTaxableIncome += discTaxableIncome;
                discTotalVatValue += discVatValue;
                rowsTaxableIncome.set(i, new BigDecimal(((BigDecimal)rowsTaxableIncome.get(i)).doubleValue() - discTaxableIncome));
                ++i;
            }
            totalRowsVat = new BigDecimal(totalRowsVat.doubleValue() - discTotalVatValue);
            totalRowsTaxableIncome = new BigDecimal(totalRowsTaxableIncome.doubleValue() - discTotalTaxableIncome);
        }
        totalDocVat = new BigDecimal(totalDocVat.doubleValue() - discTotalVatValue);
        totalDocTaxableIncome = new BigDecimal(totalDocTaxableIncome.doubleValue() - discTotalTaxableIncome);
        double chargeTaxableIncome = 0.0;
        double chargeVatValue = 0.0;
        double chargeTotalTaxableIncome = 0.0;
        double chargeTotalVatValue = 0.0;
        if (vo.getChargeValueDOC06() != null) {
            int i2 = 0;
            while (i2 < rowsTaxableIncome.size()) {
                chargeTaxableIncome = ((BigDecimal)rowsTaxableIncome.get(i2)).doubleValue() / totalRowsTaxableIncome.doubleValue() * vo.getChargeValueDOC06().doubleValue();
                chargeVatValue = chargeTaxableIncome * ((BigDecimal)rowsVatValue.get(i2)).doubleValue() / 100.0;
                chargeTotalTaxableIncome += chargeTaxableIncome;
                chargeTotalVatValue += chargeVatValue;
                ++i2;
            }
        }
        if (vo.getChargePercDOC06() != null && vo.getChargePercDOC06().intValue() > 0) {
            chargeTotalTaxableIncome = totalDocTaxableIncome.doubleValue() * vo.getChargePercDOC06().doubleValue() / 100.0;
            chargeTotalVatValue = totalDocVat.doubleValue() * vo.getChargePercDOC06().doubleValue() / 100.0;
        }
        totalDocVat = totalDocVat.add(new BigDecimal(chargeTotalVatValue));
        totalDocTaxableIncome = totalDocTaxableIncome.add(new BigDecimal(chargeTotalTaxableIncome));
        vo.setTaxableIncomeDOC06(totalDocTaxableIncome.setScale(vo.getDecimalsREG03().intValue(), 4));
        vo.setTotalVatDOC06(totalDocVat.setScale(vo.getDecimalsREG03().intValue(), 4));
        vo.setTotalDOC06(vo.getTaxableIncomeDOC06().add(vo.getTotalVatDOC06()).setScale(vo.getDecimalsREG03().intValue(), 4));
        VOResponse answer = new VOResponse((Object)vo);
        EventsManager.getInstance().processEvent(new GenericEvent(this, "PurchaseDocTotalsBean.calcDocTotals", 1, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, (Object)vo, answer));
        VOResponse vOResponse = answer;
        Object var36_30 = null;
        try {
            pstmt.close();
        }
        catch (Exception ex2) {
        }
        return vOResponse;
        catch (Throwable ex) {
            ErrorResponse errorResponse;
            try {
                Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"calcDocTotals", (String)"Error on calculating purchase order totals", (Throwable)ex);
                errorResponse = new ErrorResponse(ex.getMessage());
                Object var36_31 = null;
            }
            catch (Throwable throwable) {
                Object var36_32 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
            try {
                pstmt.close();
            }
            catch (Exception ex2) {
            }
            return errorResponse;
        }
    }
}

