/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.registers.currency.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CurrencyConversionUtils {
    public static final BigDecimal convertCurrencyToCurrency(BigDecimal value, BigDecimal conversionFactor) {
        if (value == null) {
            return null;
        }
        return value.multiply(conversionFactor).setScale(value.scale(), 4);
    }

    public static final BigDecimal convertCurrencyToCurrency(BigDecimal value, String fromCurrencyCode, String toCurrencyCode, Connection conn) throws Exception {
        return CurrencyConversionUtils.convertCurrencyToCurrency(value, CurrencyConversionUtils.getConversionFactor(fromCurrencyCode, toCurrencyCode, conn));
    }

    public static final BigDecimal getCompanyConversionFactor(String fromCurrencyCode, String companyCode, Connection conn) throws Exception {
        return CurrencyConversionUtils.getConversionFactor(fromCurrencyCode, CurrencyConversionUtils.getCompanyCurrencyCode(companyCode, conn), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final String getCompanyCurrencyCode(String companyCode, Connection conn) throws Exception {
        String toCurrencyCode;
        boolean error;
        String errorMsg;
        block11: {
            Statement stmt = null;
            errorMsg = null;
            error = false;
            toCurrencyCode = null;
            String sql = "select CURRENCY_CODE_REG03 from SYS01_COMPANIES where COMPANY_CODE='" + companyCode + "'";
            stmt = conn.createStatement();
            ResultSet rset = stmt.executeQuery(sql);
            if (rset.next()) {
                toCurrencyCode = rset.getString(1);
            } else {
                error = true;
                errorMsg = "no company found";
            }
            rset.close();
            Object var9_9 = null;
            try {
                stmt.close();
            }
            catch (Exception ex2) {
            }
            break block11;
            {
                catch (Throwable ex) {
                    error = true;
                    errorMsg = ex.toString();
                    Object var9_10 = null;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    stmt.close();
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
        }
        if (error) {
            throw new Exception(errorMsg);
        }
        return toCurrencyCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final BigDecimal getConversionFactor(String fromCurrencyCode, String toCurrencyCode, Connection conn) throws Exception {
        BigDecimal conv;
        boolean error;
        String errorMsg;
        block13: {
            Statement stmt;
            block12: {
                if (fromCurrencyCode.equals(toCurrencyCode)) {
                    return new BigDecimal(1.0);
                }
                stmt = null;
                errorMsg = null;
                error = false;
                conv = null;
                String sql = "select REG06_CURRENCY_CONV.VALUE from REG06_CURRENCY_CONV where REG06_CURRENCY_CONV.CURRENCY_CODE_REG03='" + fromCurrencyCode + "' and " + "REG06_CURRENCY_CONV.CURRENCY_CODE2_REG03='" + toCurrencyCode + "'";
                stmt = conn.createStatement();
                ResultSet rset = stmt.executeQuery(sql);
                if (rset.next()) {
                    conv = rset.getBigDecimal(1);
                } else {
                    error = true;
                    errorMsg = "no currency defined";
                }
                rset.close();
                if (conv != null) break block12;
                error = true;
                errorMsg = "no currency conversion defined";
            }
            Object var10_10 = null;
            try {
                stmt.close();
            }
            catch (Exception ex2) {
            }
            break block13;
            {
                catch (Throwable ex) {
                    error = true;
                    errorMsg = ex.toString();
                    Object var10_11 = null;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    stmt.close();
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
        }
        if (error) {
            throw new Exception(errorMsg);
        }
        return conv;
    }
}

