/*
 * Decompiled with CFR 0.152.
 */
package org.jruleengine;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jruleengine.RuleExecutionSetImpl;
import org.jruleengine.rule.Action;
import org.jruleengine.rule.Assumption;
import org.jruleengine.rule.RuleImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LocalRuleExecutionSetProviderImpl
implements LocalRuleExecutionSetProvider {
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";

    LocalRuleExecutionSetProviderImpl() {
    }

    private RuleExecutionSet createRuleExecutionSet(Element docElement, Map properties) throws RuleExecutionSetCreateException {
        try {
            NodeList contents = docElement.getElementsByTagName(NAME);
            if (contents.getLength() == 0) {
                throw new RuleExecutionSetCreateException("Name not specified");
            }
            String name = contents.item(0).getFirstChild().getNodeValue().trim();
            contents = docElement.getElementsByTagName(DESCRIPTION);
            if (contents.getLength() == 0) {
                throw new RuleExecutionSetCreateException("Description not specified");
            }
            String description = contents.item(0).getFirstChild().getNodeValue().trim();
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            properties.put(NAME, name);
            properties.put(DESCRIPTION, description);
            Element node = null;
            ArrayList<Assumption> assumptions = null;
            ArrayList<Action> actions = null;
            NodeList nodes = null;
            Hashtable<String, String> synonymns = new Hashtable<String, String>();
            nodes = docElement.getElementsByTagName("synonymn");
            int j = 0;
            while (j < nodes.getLength()) {
                node = (Element)nodes.item(j);
                synonymns.put(node.getAttribute(NAME), node.getAttribute("class"));
                ++j;
            }
            contents = docElement.getElementsByTagName("rule");
            ArrayList<RuleImpl> rules = new ArrayList<RuleImpl>();
            int i = 0;
            while (i < contents.getLength()) {
                Element el = (Element)contents.item(i);
                assumptions = new ArrayList<Assumption>();
                actions = new ArrayList<Action>();
                nodes = el.getElementsByTagName("if");
                int j2 = 0;
                while (j2 < nodes.getLength()) {
                    node = (Element)nodes.item(j2);
                    if (node.getAttributeNode("op") != null && node.getAttributeNode("op").getValue() != null && node.getAttributeNode("rightTerm") != null && node.getAttributeNode("rightTerm").getValue() != null) {
                        assumptions.add(new Assumption(this.parseClassName(node.getAttribute("leftTerm"), synonymns), node.getAttribute("op"), this.parseClassName(node.getAttribute("rightTerm"), synonymns)));
                    } else {
                        assumptions.add(new Assumption(this.parseClassName(node.getAttribute("leftTerm"), synonymns)));
                    }
                    ++j2;
                }
                ArrayList<String> args = null;
                nodes = el.getElementsByTagName("then");
                int j3 = 0;
                while (j3 < nodes.getLength()) {
                    node = (Element)nodes.item(j3);
                    args = new ArrayList<String>();
                    int k = 1;
                    while (node.getAttributeNode("arg" + k) != null && node.getAttributeNode("arg" + k).getValue() != null) {
                        args.add(this.parseClassName(node.getAttribute("arg" + k), synonymns));
                        ++k;
                    }
                    actions.add(new Action(this.parseClassName(node.getAttribute("method"), synonymns), args));
                    ++j3;
                }
                rules.add(new RuleImpl(el.getAttribute(NAME), el.getAttribute(DESCRIPTION), assumptions, actions));
                ++i;
            }
            return this.createRuleExecutionSetFromRuleList(rules, properties);
        }
        catch (Exception ex) {
            throw new RuleExecutionSetCreateException(ex.getMessage());
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Object ast, Map properties) throws RuleExecutionSetCreateException {
        if (ast == null || !(ast instanceof Collection)) {
            throw new RuleExecutionSetCreateException("Invalid type argument: AST argument must be a collection of RuleImpl objects");
        }
        if (properties == null) {
            properties = new HashMap();
        }
        try {
            return this.createRuleExecutionSetFromRuleList((Collection)ast, properties);
        }
        catch (Exception ex) {
            throw new RuleExecutionSetCreateException(ex.getMessage());
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Reader reader, Map props) throws RuleExecutionSetCreateException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new InputSource(reader));
        }
        catch (Exception e) {
            throw new RuleExecutionSetCreateException("Parse error", e);
        }
        return this.createRuleExecutionSet(doc.getDocumentElement(), props);
    }

    public RuleExecutionSet createRuleExecutionSet(InputStream inputStream, Map props) throws RuleExecutionSetCreateException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new InputSource(inputStream));
        }
        catch (Exception e) {
            throw new RuleExecutionSetCreateException("Parse error", e);
        }
        return this.createRuleExecutionSet(doc.getDocumentElement(), props);
    }

    private RuleExecutionSet createRuleExecutionSetFromRuleList(Collection rules, Map props) throws RuleExecutionSetCreateException, IOException {
        try {
            String name = "Untitled";
            String description = "Generic rule execution set";
            if (props != null) {
                if (props.get(NAME) != null) {
                    name = (String)props.get(NAME);
                }
                if (props.get(DESCRIPTION) != null) {
                    description = (String)props.get(DESCRIPTION);
                }
            }
            RuleExecutionSetImpl rs = new RuleExecutionSetImpl(name, description, null);
            rs.getRules().addAll(rules);
            return rs;
        }
        catch (Exception ex) {
            throw new RuleExecutionSetCreateException("Internal error", ex);
        }
    }

    private String parseClassName(String className, Hashtable synonymns) {
        if (className.indexOf(".") == -1) {
            return className;
        }
        String methodName = className.substring(className.lastIndexOf(".") + 1);
        String realClassName = (String)synonymns.get(className = className.substring(0, className.lastIndexOf(".")));
        if (realClassName != null) {
            className = realClassName;
        }
        return className + "." + methodName;
    }
}

