/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.accounts.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import org.jallinone.accounting.ledger.java.LedgerVO;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CustomizedColumns;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;

public class AccountsGridFrame
extends InternalFrame {
    BorderLayout borderLayout1;
    JPanel buttonsPanel = new JPanel();
    TextColumn colAccount;
    ComboColumn colAccountType;
    TextColumn colDescr;
    TextColumn colLedgerCode;
    TextColumn colLedgerDescr;
    ComboBoxControl controlCompaniesCombo;
    CodLookupControl controlLedgerCode;
    TextControl controlLedgerDescr;
    DeleteButton deleteButton;
    EditButton editButton;
    ExportButton exportButton;
    Form filterPanel;
    FlowLayout flowLayout1;
    GridControl grid;
    GridBagLayout gridBagLayout1;
    private ServerGridDataLocator gridDataLocator;
    InsertButton insertButton;
    LabelControl labelCompany;
    LabelControl labelLedger;
    LookupController ledgerController;
    LookupServerDataLocator ledgerDataLocator;
    NavigatorBar navigatorBar;
    ReloadButton reloadButton;
    SaveButton saveButton;
    JPanel topPanel = new JPanel();

    public AccountsGridFrame(GridController controller) {
        this.filterPanel = new Form();
        this.borderLayout1 = new BorderLayout();
        this.flowLayout1 = new FlowLayout();
        this.insertButton = new InsertButton();
        this.reloadButton = new ReloadButton();
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.gridDataLocator = new ServerGridDataLocator();
        this.colAccount = new TextColumn();
        this.colDescr = new TextColumn();
        this.colAccountType = new ComboColumn();
        this.colLedgerCode = new TextColumn();
        this.colLedgerDescr = new TextColumn();
        this.exportButton = new ExportButton();
        this.labelLedger = new LabelControl();
        this.controlLedgerCode = new CodLookupControl();
        this.controlLedgerDescr = new TextControl();
        this.ledgerController = new LookupController();
        this.ledgerDataLocator = new LookupServerDataLocator();
        this.labelCompany = new LabelControl();
        this.controlCompaniesCombo = new ComboBoxControl();
        this.gridBagLayout1 = new GridBagLayout();
        this.grid.setController(controller);
        this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
        this.gridDataLocator.setServerMethodName("loadAccounts");
        try {
            this.jbInit();
            this.setSize(750, 400);
            this.setMinimumSize(new Dimension(750, 400));
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("ACC01");
            Domain domain = new Domain("DOMAIN_ACC01");
            int i = 0;
            while (i < companiesList.size()) {
                if (applet.getAuthorizations().getCompanyBa().isInsertEnabled("ACC01", companiesList.get(i).toString())) {
                    domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
                }
                ++i;
            }
            this.controlCompaniesCombo.setDomain(domain);
            this.controlCompaniesCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AccountsGridFrame.this.grid.getOtherGridParams().put("COMPANY_CODE_SYS01", AccountsGridFrame.this.controlCompaniesCombo.getValue());
                    }
                }
            });
            try {
                this.controlCompaniesCombo.getComboBox().setSelectedIndex(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.controlLedgerCode.setLookupController(this.ledgerController);
            this.controlLedgerCode.setControllerMethodName("getLedger");
            this.ledgerController.setLookupDataLocator((LookupDataLocator)this.ledgerDataLocator);
            this.ledgerDataLocator.setGridMethodName("loadLedger");
            this.ledgerDataLocator.setValidationMethodName("validateLedgerCode");
            this.ledgerController.setFrameTitle("ledger");
            this.ledgerController.setLookupValueObjectClassName("org.jallinone.accounting.ledger.java.LedgerVO");
            this.ledgerController.addLookup2ParentLink("ledgerCodeACC01", "ledgerCodeACC01");
            this.ledgerController.addLookup2ParentLink("descriptionSYS10", "descriptionSYS10");
            this.ledgerController.setFramePreferedSize(new Dimension(400, 400));
            this.ledgerController.setAllColumnVisible(false);
            this.ledgerController.setVisibleColumn("ledgerCodeACC01", true);
            this.ledgerController.setVisibleColumn("descriptionSYS10", true);
            this.ledgerController.setPreferredWidthColumn("descriptionSYS10", 290);
            this.ledgerController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    AccountsGridFrame.this.ledgerDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", AccountsGridFrame.this.controlCompaniesCombo.getValue());
                    AccountsGridFrame.this.ledgerDataLocator.getLookupValidationParameters().put("COMPANY_CODE_SYS01", AccountsGridFrame.this.controlCompaniesCombo.getValue());
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    LedgerVO vo = (LedgerVO)parentVO;
                    AccountsGridFrame.this.grid.getOtherGridParams().put("COMPANY_CODE_SYS01", AccountsGridFrame.this.controlCompaniesCombo.getValue());
                    if (vo.getLedgerCodeACC01() != null && !vo.getLedgerCodeACC01().equals("")) {
                        AccountsGridFrame.this.grid.getOtherGridParams().put("LEDGER_CODE", vo.getLedgerCodeACC01());
                    } else {
                        AccountsGridFrame.this.grid.getOtherGridParams().remove("LEDGER_CODE");
                    }
                    AccountsGridFrame.this.grid.reloadData();
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            CustomizedColumns cust = new CustomizedColumns(ApplicationConsts.ID_ACCOUNTS, this.grid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ComboBoxControl getControlCompaniesCombo() {
        return this.controlCompaniesCombo;
    }

    public CodLookupControl getControlLedgerCode() {
        return this.controlLedgerCode;
    }

    public TextControl getControlLedgerDescr() {
        return this.controlLedgerDescr;
    }

    private void jbInit() throws Exception {
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.filterPanel.setVOClassName("org.jallinone.accounting.ledger.java.LedgerVO");
        this.labelCompany.setText("companyCode");
        this.topPanel.setLayout(this.borderLayout1);
        this.labelLedger.setText("ledgerCodeACC01");
        this.filterPanel.setLayout((LayoutManager)this.gridBagLayout1);
        this.controlLedgerDescr.setColumns(30);
        this.controlLedgerDescr.setEnabled(false);
        this.controlLedgerCode.setLinkLabel(this.labelLedger);
        this.controlLedgerCode.setAttributeName("ledgerCodeACC01");
        this.controlLedgerCode.setMaxCharacters(20);
        this.controlLedgerDescr.setAttributeName("descriptionSYS10");
        this.topPanel.add((Component)this.filterPanel, "North");
        this.filterPanel.add((Component)this.labelCompany, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlCompaniesCombo, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 60, 0));
        this.filterPanel.add((Component)this.labelLedger, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.topPanel.add((Component)this.buttonsPanel, "South");
        this.grid.setSelectionMode(2);
        this.saveButton.setExecuteAsThread(true);
        this.grid.setValueObjectClassName("org.jallinone.accounting.accounts.java.AccountVO");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("accounts"));
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.grid.setDeleteButton(this.deleteButton);
        this.grid.setEditButton(this.editButton);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("ACC02");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton);
        this.colAccount.setMaxCharacters(20);
        this.colAccount.setTrimText(true);
        this.colAccount.setUpperCase(true);
        this.colAccount.setColumnFilterable(true);
        this.colAccount.setColumnName("accountCodeACC02");
        this.colAccount.setColumnSortable(true);
        this.colAccount.setEditableOnInsert(true);
        this.colAccount.setSortVersus("ASC");
        this.colAccount.setSortingOrder(2);
        this.colDescr.setColumnFilterable(false);
        this.colDescr.setColumnName("descriptionSYS10");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setEditableOnEdit(true);
        this.colDescr.setEditableOnInsert(true);
        this.colDescr.setPreferredWidth(220);
        this.colAccountType.setColumnFilterable(true);
        this.colAccountType.setColumnName("accountTypeACC02");
        this.colAccountType.setColumnSortable(true);
        this.colAccountType.setEditableOnEdit(false);
        this.colAccountType.setEditableOnInsert(true);
        this.colAccountType.setPreferredWidth(120);
        this.colAccountType.setDomainId("ACCOUNT_TYPE_ACC02");
        this.colLedgerCode.setColumnFilterable(true);
        this.colLedgerCode.setColumnName("ledgerCodeAcc01ACC02");
        this.colLedgerCode.setColumnSortable(true);
        this.colLedgerCode.setEditableOnEdit(false);
        this.colLedgerCode.setEditableOnInsert(false);
        this.colLedgerCode.setPreferredWidth(80);
        this.colLedgerCode.setSortVersus("ASC");
        this.colLedgerCode.setSortingOrder(1);
        this.colLedgerDescr.setColumnFilterable(false);
        this.colLedgerDescr.setColumnName("ledgerDescriptionACC02");
        this.colLedgerDescr.setColumnSortable(false);
        this.colLedgerDescr.setEditableOnEdit(false);
        this.colLedgerDescr.setEditableOnInsert(false);
        this.colLedgerDescr.setPreferredWidth(200);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.buttonsPanel.add((Component)this.insertButton, null);
        this.buttonsPanel.add((Component)this.editButton, null);
        this.buttonsPanel.add((Component)this.saveButton, null);
        this.buttonsPanel.add((Component)this.reloadButton, null);
        this.buttonsPanel.add((Component)this.deleteButton, null);
        this.buttonsPanel.add((Component)this.exportButton, null);
        this.buttonsPanel.add((Component)this.navigatorBar, null);
        this.getContentPane().add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)this.colAccount, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.grid.getColumnContainer().add((Component)this.colAccountType, null);
        this.grid.getColumnContainer().add((Component)this.colLedgerCode, null);
        this.grid.getColumnContainer().add((Component)this.colLedgerDescr, null);
        this.filterPanel.add((Component)this.controlLedgerCode, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlLedgerDescr, (Object)new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    public final void reloadData() {
        this.grid.reloadData();
    }
}

