/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.vatregisters.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CustomizedColumns;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;

public class VatRegistersGridFrame
extends InternalFrame {
    LookupController accountController;
    LookupServerDataLocator accountDataLocator;
    JPanel buttonsPanel = new JPanel();
    CodLookupColumn colAccountCodeLookup;
    TextColumn colAccountDescr;
    TextColumn colDescr;
    ComboColumn colRegType;
    TextColumn colVatRegister;
    ComboBoxControl controlCompaniesCombo;
    DeleteButton deleteButton;
    EditButton editButton;
    ExportButton exportButton;
    GridControl grid;
    GridBagLayout gridBagLayout1;
    private ServerGridDataLocator gridDataLocator;
    InsertButton insertButton = new InsertButton();
    LabelControl labelCompany;
    NavigatorBar navigatorBar;
    ReloadButton reloadButton = new ReloadButton();
    SaveButton saveButton;

    public VatRegistersGridFrame(GridController controller) {
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.gridDataLocator = new ServerGridDataLocator();
        this.colVatRegister = new TextColumn();
        this.colDescr = new TextColumn();
        this.colRegType = new ComboColumn();
        this.labelCompany = new LabelControl();
        this.controlCompaniesCombo = new ComboBoxControl();
        this.exportButton = new ExportButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.colAccountCodeLookup = new CodLookupColumn();
        this.colAccountDescr = new TextColumn();
        this.accountController = new LookupController();
        this.accountDataLocator = new LookupServerDataLocator();
        this.grid.setController(controller);
        this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
        this.gridDataLocator.setServerMethodName("loadVatRegisters");
        try {
            this.jbInit();
            this.setSize(750, 300);
            this.setMinimumSize(new Dimension(750, 300));
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("ACC04");
            Domain domain = new Domain("DOMAIN_ACC04");
            int i = 0;
            while (i < companiesList.size()) {
                if (applet.getAuthorizations().getCompanyBa().isInsertEnabled("ACC04", companiesList.get(i).toString())) {
                    domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
                }
                ++i;
            }
            this.controlCompaniesCombo.setDomain(domain);
            this.controlCompaniesCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        VatRegistersGridFrame.this.grid.getOtherGridParams().put("COMPANY_CODE_SYS01", VatRegistersGridFrame.this.controlCompaniesCombo.getValue());
                    }
                }
            });
            try {
                this.controlCompaniesCombo.getComboBox().setSelectedIndex(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.colAccountCodeLookup.setLookupController(this.accountController);
            this.colAccountCodeLookup.setControllerMethodName("getAccounts");
            this.accountController.setLookupDataLocator((LookupDataLocator)this.accountDataLocator);
            this.accountDataLocator.setGridMethodName("loadAccounts");
            this.accountDataLocator.setValidationMethodName("validateAccountCode");
            this.accountController.setFrameTitle("accounts");
            this.accountController.setAllowTreeLeafSelectionOnly(false);
            this.accountController.setLookupValueObjectClassName("org.jallinone.accounting.accounts.java.AccountVO");
            this.accountController.addLookup2ParentLink("accountCodeACC02", "accountCodeAcc02ACC04");
            this.accountController.addLookup2ParentLink("descriptionSYS10", "accountDescriptionACC04");
            this.accountController.setFramePreferedSize(new Dimension(400, 400));
            this.accountController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    VatRegistersGridFrame.this.accountDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", VatRegistersGridFrame.this.controlCompaniesCombo.getValue());
                    VatRegistersGridFrame.this.accountDataLocator.getLookupValidationParameters().put("COMPANY_CODE_SYS01", VatRegistersGridFrame.this.controlCompaniesCombo.getValue());
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            CustomizedColumns cust = new CustomizedColumns(ApplicationConsts.ID_VAT_REGISTERS, this.grid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ComboBoxControl getControlCompaniesCombo() {
        return this.controlCompaniesCombo;
    }

    private void jbInit() throws Exception {
        this.labelCompany.setText("companyCode");
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.grid.setSelectionMode(2);
        this.saveButton.setExecuteAsThread(true);
        this.grid.setValueObjectClassName("org.jallinone.accounting.vatregisters.java.VatRegisterVO");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("vat register"));
        this.buttonsPanel.setLayout(this.gridBagLayout1);
        this.grid.setDeleteButton(this.deleteButton);
        this.grid.setEditButton(this.editButton);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("ACC04");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton);
        this.colVatRegister.setMaxCharacters(20);
        this.colVatRegister.setTrimText(true);
        this.colVatRegister.setUpperCase(true);
        this.colVatRegister.setColumnFilterable(true);
        this.colVatRegister.setColumnName("registerCodeACC04");
        this.colVatRegister.setColumnSortable(true);
        this.colVatRegister.setEditableOnInsert(true);
        this.colVatRegister.setSortVersus("ASC");
        this.colVatRegister.setSortingOrder(1);
        this.colVatRegister.setPreferredWidth(80);
        this.colDescr.setColumnFilterable(false);
        this.colDescr.setColumnName("descriptionSYS10");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setEditableOnEdit(true);
        this.colDescr.setEditableOnInsert(true);
        this.colDescr.setPreferredWidth(240);
        this.colRegType.setColumnFilterable(true);
        this.colRegType.setColumnName("registerTypeACC04");
        this.colRegType.setColumnSortable(true);
        this.colRegType.setEditableOnEdit(false);
        this.colRegType.setEditableOnInsert(true);
        this.colRegType.setPreferredWidth(120);
        this.colRegType.setDomainId("REGISTER_TYPE_ACC04");
        this.colAccountCodeLookup.setColumnFilterable(true);
        this.colAccountCodeLookup.setColumnName("accountCodeAcc02ACC04");
        this.colAccountCodeLookup.setColumnSortable(true);
        this.colAccountCodeLookup.setEditableOnEdit(false);
        this.colAccountCodeLookup.setEditableOnInsert(true);
        this.colAccountCodeLookup.setPreferredWidth(80);
        this.colAccountDescr.setColumnFilterable(false);
        this.colAccountDescr.setColumnName("accountDescriptionACC04");
        this.colAccountDescr.setColumnSortable(false);
        this.colAccountDescr.setEditableOnEdit(false);
        this.colAccountDescr.setEditableOnInsert(false);
        this.colAccountDescr.setPreferredWidth(200);
        this.getContentPane().add((Component)this.buttonsPanel, "North");
        this.buttonsPanel.add((Component)this.insertButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.editButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.saveButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.reloadButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.deleteButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.exportButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.navigatorBar, new GridBagConstraints(6, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.labelCompany, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 5), 0, 0));
        this.buttonsPanel.add((Component)this.controlCompaniesCombo, new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.getContentPane().add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)this.colVatRegister, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.grid.getColumnContainer().add((Component)this.colRegType, null);
        this.grid.getColumnContainer().add((Component)this.colAccountCodeLookup, null);
        this.grid.getColumnContainer().add((Component)this.colAccountDescr, null);
    }

    public final void reloadData() {
        this.grid.reloadData();
    }
}

