/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.documents.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.documents.client.DocumentsFrame;
import org.jallinone.documents.java.LevelPropertyVO;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class DocFilterPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    private Hashtable filters;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel innerPanel = new Form();
    JScrollPane sp = new JScrollPane();
    TitledBorder titledBorder1;

    public DocFilterPanel() {
        this.filters = new Hashtable();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
        }
    }

    public final void clearData() {
        this.innerPanel.removeAll();
        this.innerPanel.revalidate();
        this.innerPanel.repaint();
        this.filters.clear();
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.setLayout(this.borderLayout1);
        this.setBorder(this.titledBorder1);
        this.titledBorder1.setTitleColor(Color.blue);
        this.titledBorder1.setTitle(ClientSettings.getInstance().getResources().getResource("documents filter"));
        this.add((Component)this.sp, "Center");
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        this.sp.getViewport().add((Component)this.innerPanel, null);
        this.sp.setAutoscrolls(true);
        this.innerPanel.setLayout(this.gridBagLayout1);
    }

    public final void reloadData(DocumentsFrame frame) {
        try {
            this.clearData();
            frame.getGrid().getOtherGridParams().put("PROPERTIES_FILTER", this.filters);
            GridParams gridParams = new GridParams();
            DefaultMutableTreeNode node = frame.getHierarTreePanel().getSelectedNode();
            if (node != null) {
                HierarchyLevelVO vo = (HierarchyLevelVO)((Object)node.getUserObject());
                HierarchyLevelVO root = (HierarchyLevelVO)((Object)((DefaultMutableTreeNode)node.getRoot()).getUserObject());
                gridParams.getOtherGridParams().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
                gridParams.getOtherGridParams().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
            } else {
                gridParams.getOtherGridParams().remove("PROGRESSIVE_HIE01");
            }
            gridParams.getOtherGridParams().put("PROGRESSIVE_HIE02", frame.getHierarTreePanel().getProgressiveHIE02());
            gridParams.getOtherGridParams().put("LOAD_ANCIENTS", Boolean.TRUE);
            Response res = ClientUtils.getData((String)"loadLevelProperties", (Object)gridParams);
            if (res.isError()) {
                JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)this), ClientSettings.getInstance().getResources().getResource("Error while loading data") + ":\n" + res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
                return;
            }
            List rows = ((VOListResponse)res).getRows();
            if (rows.size() > 0) {
                LevelPropertyVO inputControlInfo = null;
                int row = 0;
                int col = 0;
                LabelControl labelControl = null;
                TextControl textControl = null;
                DateControl dateControl = null;
                NumericControl numericControl = null;
                int i = 0;
                while (i < rows.size()) {
                    inputControlInfo = (LevelPropertyVO)((Object)rows.get(i));
                    labelControl = new LabelControl();
                    labelControl.setText(inputControlInfo.getDescriptionSYS10());
                    this.innerPanel.add((Component)labelControl, new GridBagConstraints(col++, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                    if (inputControlInfo.getPropertyTypeDOC21().equals("T")) {
                        textControl = new TextControl();
                        textControl.setMaxCharacters(255);
                        textControl.setLinkLabel(labelControl);
                        this.innerPanel.add((Component)textControl, new GridBagConstraints(col, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 15), 0, 0));
                        textControl.addFocusListener((FocusListener)new ControlFocusListener(inputControlInfo, (BaseInputControl)textControl));
                    } else if (inputControlInfo.getPropertyTypeDOC21().equals("D")) {
                        dateControl = new DateControl();
                        dateControl.setLinkLabel(labelControl);
                        this.innerPanel.add((Component)dateControl, new GridBagConstraints(col, row, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 15), 0, 0));
                        dateControl.addFocusListener((FocusListener)new ControlFocusListener(inputControlInfo, (BaseInputControl)dateControl));
                    } else if (inputControlInfo.getPropertyTypeDOC21().equals("N")) {
                        numericControl = new NumericControl();
                        numericControl.setDecimals(5);
                        numericControl.setLinkLabel(labelControl);
                        this.innerPanel.add((Component)numericControl, new GridBagConstraints(col, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 15), 0, 0));
                        numericControl.addFocusListener((FocusListener)new ControlFocusListener(inputControlInfo, (BaseInputControl)numericControl));
                    }
                    if (++col >= 2) {
                        this.innerPanel.add((Component)new JPanel(), new GridBagConstraints(col, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
                        ++row;
                        col = 0;
                    }
                    ++i;
                }
                this.innerPanel.add((Component)new JPanel(), new GridBagConstraints(col, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.innerPanel.add((Component)new JPanel(), new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
                this.revalidate();
                this.repaint();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class ControlFocusListener
    extends FocusAdapter {
        private BaseInputControl control;
        private LevelPropertyVO inputControlInfo;

        public ControlFocusListener(LevelPropertyVO inputControlInfo, BaseInputControl control) {
            this.inputControlInfo = inputControlInfo;
            this.control = control;
        }

        public void focusLost(FocusEvent e) {
            if (this.control.getValue() == null || this.control.getValue().toString().equals("")) {
                DocFilterPanel.this.filters.remove(this.inputControlInfo.getProgressiveSys10DOC21());
            } else {
                DocFilterPanel.this.filters.put(this.inputControlInfo.getProgressiveSys10DOC21(), this.control.getValue());
            }
        }
    }
}

