/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.documents.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.documents.client.DocumentFrame;
import org.jallinone.documents.client.DocumentsFrame;
import org.jallinone.documents.java.DetailDocumentVO;
import org.jallinone.documents.java.DocumentPK;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class DocumentController
extends CompanyFormController {
    private DocumentFrame frame = null;
    private DocumentsFrame parentFrame = null;
    private DocumentPK pk = null;
    private BigDecimal progressiveHie01DOC17 = null;

    public DocumentController(DocumentsFrame parentFrame, DocumentPK pk, BigDecimal progressiveHie01DOC17) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.progressiveHie01DOC17 = progressiveHie01DOC17;
        this.frame = new DocumentFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getFormPanel().setMode(0);
            this.frame.getFormPanel().executeReload();
        } else {
            this.frame.getFormPanel().insert();
        }
    }

    public void afterInsertData(Form form) {
        this.frame.setButtonsEnabled(false);
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getLinksgrid().clearData();
            this.frame.getVgrid().clearData();
            this.frame.getPropPanel().clearData();
            this.frame.getControlDocSize().setText("");
        }
        return ok;
    }

    public void createPersistentObject(ValueObject PersistentObject) throws Exception {
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<DocumentPK> pks = new ArrayList<DocumentPK>();
        DetailDocumentVO vo = (DetailDocumentVO)persistentObject;
        DocumentPK pk = new DocumentPK(vo.getCompanyCodeSys01DOC14(), vo.getProgressiveDOC14());
        pks.add(pk);
        Response res = ClientUtils.getData((String)"deleteDocuments", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getLinksgrid().clearData();
            this.frame.getVgrid().clearData();
            this.frame.getPropPanel().clearData();
        }
        return res;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        DetailDocumentVO vo = (DetailDocumentVO)newPersistentObject;
        vo.setProgressiveHie01DOC17(this.progressiveHie01DOC17);
        if (vo.getDocument() == null) {
            return new ErrorResponse("you must attach a file");
        }
        Response res = ClientUtils.getData((String)"insertDocument", (Object)((Object)vo));
        if (!res.isError()) {
            vo = (DetailDocumentVO)((Object)((VOResponse)res).getVo());
            vo.setDocument(null);
            this.frame.getControlDocSize().setText("");
            this.pk = new DocumentPK(vo.getCompanyCodeSys01DOC14(), vo.getProgressiveDOC14());
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getLinksgrid().getOtherGridParams().put("DOCUMENT_PK", this.pk);
            this.frame.getLinksgrid().reloadData();
            this.frame.getVgrid().getOtherGridParams().put("DOCUMENT_PK", this.pk);
            this.frame.getVgrid().reloadData();
            this.frame.getPropPanel().reloadData(this.frame);
            this.frame.setButtonsEnabled(true);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadDocument", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        DetailDocumentVO vo = (DetailDocumentVO)persistentObject;
        Response res = ClientUtils.getData((String)"updateDocument", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError()) {
            vo = (DetailDocumentVO)((Object)((VOResponse)res).getVo());
            vo.setDocument(null);
            this.frame.getVgrid().reloadData();
            this.frame.getPropPanel().reloadData(this.frame);
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
        }
        return res;
    }
}

