/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.documents.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jallinone.documents.client.DocFilterPanel;
import org.jallinone.documents.client.DocumentsController;
import org.jallinone.documents.java.DocumentTypeVO;
import org.jallinone.hierarchies.client.HierarTreePanel;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class DocumentsFrame
extends InternalFrame {
    JPanel buttonsPanel = new JPanel();
    TextColumn colCod;
    TextColumn colCompany;
    TextColumn colDescr;
    ComboBoxControl comboBoxControl1;
    DeleteButton deleteButton1;
    ExportButton exportButton1;
    DocFilterPanel filterPanel;
    GridControl grid;
    GridBagLayout gridBagLayout1;
    private ServerGridDataLocator gridDataLocator;
    HierarTreePanel hierarTreePanel;
    InsertButton insertButton1;
    LabelControl labelDocumentType;
    NavigatorBar navigatorBar1;
    ReloadButton reloadButton1;
    JSplitPane split = new JSplitPane();
    JSplitPane subsplit;

    public DocumentsFrame(DocumentsController documentsController) {
        this.labelDocumentType = new LabelControl();
        this.insertButton1 = new InsertButton();
        this.reloadButton1 = new ReloadButton();
        this.deleteButton1 = new DeleteButton();
        this.exportButton1 = new ExportButton();
        this.navigatorBar1 = new NavigatorBar();
        this.gridBagLayout1 = new GridBagLayout();
        this.comboBoxControl1 = new ComboBoxControl();
        this.hierarTreePanel = new HierarTreePanel();
        this.grid = new GridControl();
        this.colCod = new TextColumn();
        this.colDescr = new TextColumn();
        this.colCompany = new TextColumn();
        this.subsplit = new JSplitPane();
        this.filterPanel = new DocFilterPanel();
        this.gridDataLocator = new ServerGridDataLocator();
        try {
            this.jbInit();
            this.setSize(750, 550);
            this.setMinimumSize(new Dimension(750, 500));
            this.grid.setController((GridController)documentsController);
            this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
            this.gridDataLocator.setServerMethodName("loadDocuments");
            this.hierarTreePanel.setFunctionId("DOC16");
            this.hierarTreePanel.setTreeController(documentsController);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DocFilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public GridControl getGrid() {
        return this.grid;
    }

    public ServerGridDataLocator getGridDataLocator() {
        return this.gridDataLocator;
    }

    public HierarTreePanel getHierarTreePanel() {
        return this.hierarTreePanel;
    }

    private void init() {
        Response res = ClientUtils.getData((String)"loadDocumentTypes", (Object)new GridParams());
        Domain d = new Domain("DOCUMENT_TYPES");
        if (!res.isError()) {
            DocumentTypeVO vo = null;
            List list = ((VOListResponse)res).getRows();
            int i = 0;
            while (i < list.size()) {
                vo = (DocumentTypeVO)((Object)list.get(i));
                d.addDomainPair((Object)vo.getProgressiveHie02DOC16(), vo.getDescriptionSYS10());
                ++i;
            }
        }
        this.comboBoxControl1.setDomain(d);
        this.comboBoxControl1.getComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DocumentsFrame.this.hierarTreePanel.setProgressiveHIE02((BigDecimal)DocumentsFrame.this.comboBoxControl1.getValue());
                    DocumentsFrame.this.hierarTreePanel.reloadTree();
                    DocumentsFrame.this.grid.clearData();
                    DocumentsFrame.this.filterPanel.clearData();
                }
            }
        });
        if (d.getDomainPairList().length >= 1) {
            this.comboBoxControl1.getComboBox().setSelectedIndex(0);
        } else {
            this.comboBoxControl1.getComboBox().setSelectedIndex(-1);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(ClientSettings.getInstance().getResources().getResource("documents"));
        this.grid.setValueObjectClassName("org.jallinone.documents.java.GridDocumentVO");
        this.labelDocumentType.setText("document type");
        this.buttonsPanel.setLayout(this.gridBagLayout1);
        this.grid.setSelectionMode(2);
        this.colCod.setColumnFilterable(true);
        this.colCod.setColumnName("progressiveDOC14");
        this.colCod.setColumnSortable(true);
        this.colCod.setColumnVisible(false);
        this.colCod.setColumnSelectable(false);
        this.colCod.setSortingOrder(2);
        this.colDescr.setColumnFilterable(true);
        this.colDescr.setColumnName("descriptionDOC14");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setPreferredWidth(400);
        this.colDescr.setSortingOrder(0);
        this.colDescr.setSortVersus("ASC");
        this.colCompany.setColumnFilterable(true);
        this.colCompany.setColumnName("companyCodeSys01DOC14");
        this.colCompany.setColumnSortable(true);
        this.colCompany.setSortVersus("ASC");
        this.colCompany.setSortingOrder(1);
        this.grid.setAutoLoadData(false);
        this.grid.setDeleteButton(this.deleteButton1);
        this.grid.setExportButton(this.exportButton1);
        this.grid.setFunctionId("DOC14");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton1);
        this.grid.setNavBar(this.navigatorBar1);
        this.grid.setReloadButton(this.reloadButton1);
        this.getContentPane().add((Component)this.buttonsPanel, "North");
        this.getContentPane().add((Component)this.split, "Center");
        this.buttonsPanel.add((Component)this.labelDocumentType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.insertButton1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.reloadButton1, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.deleteButton1, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.exportButton1, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.navigatorBar1, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.comboBoxControl1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 100, 0));
        this.split.add((Component)((Object)this.hierarTreePanel), "left");
        this.split.add((Component)this.subsplit, "right");
        this.subsplit.setOrientation(0);
        this.subsplit.setDividerLocation(150);
        this.subsplit.add((Component)this.filterPanel, "top");
        this.subsplit.add((Component)this.grid, "bottom");
        this.grid.getColumnContainer().add((Component)this.colCompany, null);
        this.grid.getColumnContainer().add((Component)this.colCod, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.split.setDividerLocation(210);
    }
}

