/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.employees.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.employees.client.EmployeeDetailFrame;
import org.jallinone.employees.java.DetailEmployeeVO;
import org.jallinone.scheduler.activities.java.EmployeeActivityVO;
import org.jallinone.scheduler.activities.java.ScheduledActivityPK;
import org.jallinone.scheduler.activities.java.ScheduledActivityVO;
import org.jallinone.scheduler.activities.java.ScheduledEmployeeVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class EmployeeAbsencesController
extends CompanyGridController {
    private EmployeeDetailFrame detailFrame = null;
    private GridControl grid = null;

    public EmployeeAbsencesController(EmployeeDetailFrame detailFrame, GridControl grid) {
        this.detailFrame = detailFrame;
        this.grid = grid;
    }

    private boolean checkTimes(EmployeeActivityVO vo) {
        return vo.getStartDateSCH07().getTime() <= vo.getEndDateSCH07().getTime();
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        EmployeeActivityVO vo = (EmployeeActivityVO)valueObject;
        DetailEmployeeVO empVO = (DetailEmployeeVO)this.detailFrame.getForm().getVOModel().getValueObject();
        vo.setCompanyCodeSys01SCH06((String)this.grid.getOtherGridParams().get("COMPANY_CODE_SYS01"));
        vo.setProgressiveReg04SCH07((BigDecimal)this.grid.getOtherGridParams().get("PROGRESSIVE_REG04"));
        vo.setStartDateSCH07(new Timestamp(System.currentTimeMillis()));
        vo.setEndDateSCH07(new Timestamp(System.currentTimeMillis()));
        vo.setDurationSCH07(new BigDecimal(0.0));
        vo.setEmployeeCodeSCH01(empVO.getCompanyCodeSys01SCH01());
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        EmployeeActivityVO vo = null;
        ScheduledActivityPK pk = null;
        ArrayList<ScheduledActivityPK> rows = new ArrayList<ScheduledActivityPK>();
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (EmployeeActivityVO)((Object)persistentObjects.get(i));
            pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
            rows.add(pk);
            ++i;
        }
        return ClientUtils.getData((String)"deleteScheduledActivities", rows);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        ValueObject newValueObject = (ValueObject)newValueObjects.get(0);
        if (!this.checkTimes((EmployeeActivityVO)newValueObject)) {
            return new ErrorResponse(ClientSettings.getInstance().getResources().getResource("start time must be less than end time"));
        }
        EmployeeActivityVO vo = (EmployeeActivityVO)newValueObject;
        ScheduledActivityVO actVO = new ScheduledActivityVO();
        actVO.setCompanyCodeSys01SCH06(vo.getCompanyCodeSys01SCH06());
        actVO.setCompletionPercSCH06(new BigDecimal(0.0));
        actVO.setDescriptionSCH06(vo.getDescriptionSCH06());
        actVO.setEstimatedDurationSCH06(vo.getDurationSCH07());
        actVO.setEstimatedEndDateSCH06(vo.getEndDateSCH07());
        actVO.setPrioritySCH06("N");
        actVO.setStartDateSCH06(vo.getStartDateSCH07());
        actVO.setActivityTypeSCH06(vo.getActivityTypeSCH06());
        actVO.setActivityStateSCH06("O");
        Response res = ClientUtils.getData((String)"insertScheduledActivity", (Object)((Object)actVO));
        if (res.isError()) {
            return res;
        }
        actVO = (ScheduledActivityVO)((Object)((VOResponse)res).getVo());
        ScheduledEmployeeVO schEmpVO = new ScheduledEmployeeVO();
        schEmpVO.setCompanyCodeSys01SCH07(actVO.getCompanyCodeSys01SCH06());
        schEmpVO.setProgressiveReg04SCH07(vo.getProgressiveReg04SCH07());
        schEmpVO.setDurationSCH07(vo.getDurationSCH07());
        schEmpVO.setStartDateSCH07(actVO.getStartDateSCH06());
        schEmpVO.setEndDateSCH07(vo.getEndDateSCH07());
        schEmpVO.setProgressiveSch06SCH07(actVO.getProgressiveSCH06());
        ArrayList<ScheduledEmployeeVO> list = new ArrayList<ScheduledEmployeeVO>();
        list.add(schEmpVO);
        res = ClientUtils.getData((String)"insertScheduledEmployees", list);
        if (res.isError()) {
            return res;
        }
        vo.setProgressiveSCH06(actVO.getProgressiveSCH06());
        return res;
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        EmployeeActivityVO vo = (EmployeeActivityVO)this.grid.getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("activityTypeSCH06") && newValue != null) {
            if (newValue.equals("B")) {
                vo.setDescriptionSCH06(ClientSettings.getInstance().getResources().getResource("absence"));
            } else if (newValue.equals("H")) {
                vo.setDescriptionSCH06(ClientSettings.getInstance().getResources().getResource("holiday"));
            } else if (newValue.equals("I")) {
                vo.setDescriptionSCH06(ClientSettings.getInstance().getResources().getResource("illness"));
            }
        }
        if (attributeName.equals("endDateSCH07") && newValue != null && vo.getStartDateSCH07() != null) {
            vo.setDurationSCH07(new BigDecimal((double)((((Date)newValue).getTime() - vo.getStartDateSCH07().getTime()) / 1000L / 60L)));
        } else if (attributeName.equals("startDateSCH07") && newValue != null && vo.getEndDateSCH07() != null) {
            vo.setDurationSCH07(new BigDecimal((double)((vo.getEndDateSCH07().getTime() - ((Date)newValue).getTime()) / 1000L / 60L)));
        }
        return true;
    }
}

