/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.employees.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.employees.java.EmployeeCalendarVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class EmployeeCalendarController
extends CompanyGridController {
    private GridControl grid = null;

    public EmployeeCalendarController(GridControl grid) {
        this.grid = grid;
    }

    private boolean checkTimes(EmployeeCalendarVO vo) {
        if (vo.getMorningStartHourSCH02() != null && vo.getMorningEndHourSCH02() == null || vo.getMorningStartHourSCH02() == null && vo.getMorningEndHourSCH02() != null || vo.getAfternoonStartHourSCH02() != null && vo.getAfternoonEndHourSCH02() == null || vo.getAfternoonStartHourSCH02() == null && vo.getAfternoonEndHourSCH02() != null) {
            return false;
        }
        if (vo.getMorningStartHourSCH02() != null && vo.getMorningEndHourSCH02() != null && vo.getMorningStartHourSCH02().getTime() > vo.getMorningEndHourSCH02().getTime()) {
            return false;
        }
        return vo.getAfternoonStartHourSCH02() == null || vo.getAfternoonEndHourSCH02() == null || vo.getAfternoonStartHourSCH02().getTime() <= vo.getAfternoonEndHourSCH02().getTime();
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        EmployeeCalendarVO vo = (EmployeeCalendarVO)valueObject;
        vo.setCompanyCodeSys01SCH02((String)this.grid.getOtherGridParams().get("COMPANY_CODE_SYS01"));
        vo.setProgressiveReg04SCH02((BigDecimal)this.grid.getOtherGridParams().get("PROGRESSIVE_REG04"));
        vo.setMorningStartHourSCH02(new Timestamp(28800000L));
        vo.setMorningEndHourSCH02(new Timestamp(43200000L));
        vo.setAfternoonStartHourSCH02(new Timestamp(46800000L));
        vo.setAfternoonEndHourSCH02(new Timestamp(61200000L));
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteEmployeeCalendars", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        EmployeeCalendarVO vo = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (EmployeeCalendarVO)((Object)newValueObjects.get(i));
            if (!this.checkTimes(vo)) {
                return new ErrorResponse(ClientSettings.getInstance().getResources().getResource("start time must be less than end time"));
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertEmployeeCalendars", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        int i = 0;
        while (i < persistentObjects.size()) {
            if (!this.checkTimes((EmployeeCalendarVO)((Object)persistentObjects.get(i)))) {
                return new ErrorResponse(ClientSettings.getInstance().getResources().getResource("start time must be less than end time"));
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateEmployeeCalendars", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

