/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.items.client;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.items.client.ItemController;
import org.jallinone.items.client.ItemsFrame;
import org.jallinone.items.java.GridItemVO;
import org.jallinone.items.java.ItemPK;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.util.client.ClientUtils;

public class ItemsController
extends CompanyGridController
implements TreeController {
    private ItemsFrame frame = null;
    private boolean productsOnly;

    public ItemsController(boolean productsOnly) {
        this.productsOnly = productsOnly;
        this.frame = new ItemsFrame(this, productsOnly);
        MDIFrame.add((InternalFrame)this.frame);
    }

    public boolean beforeInsertGrid(GridControl grid) {
        boolean canIns = super.beforeInsertGrid(grid);
        if (canIns) {
            new ItemController(this.frame, null, this.productsOnly);
        }
        return false;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        ArrayList<ItemPK> pks = new ArrayList<ItemPK>();
        ItemPK pk = null;
        GridItemVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (GridItemVO)((Object)persistentObjects.get(i));
            pk = new ItemPK(vo.getCompanyCodeSys01ITM01(), vo.getItemCodeITM01());
            pks.add(pk);
            ++i;
        }
        return ClientUtils.getData((String)"deleteItems", pks);
    }

    public void doubleClick(DefaultMutableTreeNode node) {
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        GridItemVO vo = (GridItemVO)persistentObject;
        ItemPK pk = new ItemPK(vo.getCompanyCodeSys01ITM01(), vo.getItemCodeITM01());
        new ItemController(this.frame, pk, this.productsOnly);
    }

    public void leftClick(DefaultMutableTreeNode node) {
        HierarchyLevelVO vo = (HierarchyLevelVO)((Object)node.getUserObject());
        HierarchyLevelVO root = (HierarchyLevelVO)((Object)((DefaultMutableTreeNode)node.getRoot()).getUserObject());
        this.frame.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02HIE01());
        this.frame.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
        this.frame.getGrid().getOtherGridParams().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
        this.frame.getGrid().reloadData();
    }

    public boolean rightClick(DefaultMutableTreeNode node) {
        return true;
    }
}

