/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.production.manufactures.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.production.manufactures.client.ManufacturesGridFrame;
import org.jallinone.production.manufactures.java.ManufacturePhaseVO;
import org.jallinone.production.manufactures.java.ManufactureVO;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class ManufacturePhasesController
extends CompanyGridController {
    private ManufacturesGridFrame gridFrame = null;

    public ManufacturePhasesController(ManufacturesGridFrame gridFrame) {
        this.gridFrame = gridFrame;
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        ManufactureVO manVO = (ManufactureVO)this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(this.gridFrame.getGrid().getSelectedRow());
        ManufacturePhaseVO vo = (ManufacturePhaseVO)valueObject;
        vo.setCompanyCodeSys01PRO02(manVO.getCompanyCodeSys01PRO01());
        vo.setManufactureCodePro01PRO02(manVO.getManufactureCodePRO01());
        vo.setCompletionPercPRO02(new BigDecimal(100.0));
        vo.setQtyPRO02(new BigDecimal(1.0));
        vo.setPhaseNumberPRO02(new BigDecimal((double)this.gridFrame.getPhasesGridControl().getVOListTableModel().getRowCount()));
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response response = ClientUtils.getData((String)"deleteManufacturePhases", (Object)persistentObjects);
        return response;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        ManufacturePhaseVO vo = null;
        Response response = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (ManufacturePhaseVO)((Object)newValueObjects.get(i));
            response = this.validatePhase(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertManufacturePhases", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        ManufacturePhaseVO vo = null;
        Response response = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (ManufacturePhaseVO)((Object)persistentObjects.get(i));
            response = this.validatePhase(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateManufacturePhases", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    private Response validatePhase(ManufacturePhaseVO vo) {
        if (vo.getManufactureTypePRO02().equals("I")) {
            if (vo.getMachineryCodePro03PRO02() == null && vo.getTaskCodeReg07PRO02() == null) {
                return new ErrorResponse("you must define either a machinery or a duty");
            }
            if (vo.getTaskCodeReg07PRO02() != null && vo.getQtyPRO02() == null) {
                return new ErrorResponse("you must define the resources number");
            }
            if (vo.getCompletionPercPRO02() != null && vo.getCompletionPercPRO02().intValue() > 100) {
                return new ErrorResponse("completion % must be between 0 and 100");
            }
            if (vo.getCompletionPercPRO02() != null && vo.getCompletionPercPRO02().intValue() < 0) {
                return new ErrorResponse("completion % must be between 0 and 100");
            }
        }
        return new VOResponse((Object)Boolean.TRUE);
    }
}

