/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.production.orders.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.production.orders.client.ProdOrderFrame;
import org.jallinone.production.orders.client.ProdOrdersFrame;
import org.jallinone.production.orders.java.DetailProdOrderVO;
import org.jallinone.production.orders.java.ProdOrderPK;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class ProdOrderController
extends CompanyFormController {
    private ProdOrderFrame frame = null;
    private ProdOrdersFrame parentFrame = null;
    private ProdOrderPK pk = null;

    public ProdOrderController(ProdOrdersFrame parentFrame, ProdOrderPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new ProdOrderFrame(this);
        MDIFrame.add((InternalFrame)this.frame, (boolean)true);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        this.frame.setButtonsEnabled(true);
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        DetailProdOrderVO vo = (DetailProdOrderVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC22().equals("C");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        DetailProdOrderVO vo = (DetailProdOrderVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC22().equals("C");
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getProductsGrid().clearData();
            this.frame.setButtonsEnabled(false);
            this.frame.getCompsGrid().clearData();
            this.frame.getConfirmButton().setEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailProdOrderVO vo = (DetailProdOrderVO)persistentObject;
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList("DOC22");
        if (companiesList.size() > 0 && vo.getCompanyCodeSys01DOC22() == null) {
            vo.setCompanyCodeSys01DOC22((String)companiesList.get(0));
        }
        Calendar cal = Calendar.getInstance();
        vo.setDocYearDOC22(new BigDecimal((double)cal.get(1)));
        vo.setDocDateDOC22(new Date(System.currentTimeMillis()));
        vo.setDocStateDOC22("O");
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<ProdOrderPK> pks = new ArrayList<ProdOrderPK>();
        DetailProdOrderVO vo = (DetailProdOrderVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deleteProdOrders", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getProductsGrid().clearData();
            this.frame.getCompsGrid().clearData();
        }
        return res;
    }

    public ProdOrdersFrame getParentFrame() {
        return this.parentFrame;
    }

    public ProdOrderPK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"insertProdOrder", (Object)newPersistentObject);
        if (!res.isError()) {
            DetailProdOrderVO vo = (DetailProdOrderVO)((Object)((VOResponse)res).getVo());
            this.pk = new ProdOrderPK(vo.getCompanyCodeSys01DOC22(), vo.getDocYearDOC22(), vo.getDocNumberDOC22());
            this.frame.getProductsGrid().getOtherGridParams().put("PROD_ORDER_PK", this.pk);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadProdOrder", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateProdOrder", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError() && this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        return res;
    }
}

