/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.documents.invoices.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.purchases.documents.invoices.client.PurchaseInvoiceDocFromDelivNotesFrame;
import org.jallinone.purchases.documents.invoices.client.PurchaseInvoiceDocsFrame;
import org.jallinone.purchases.documents.invoices.java.InDeliveryNotesVO;
import org.jallinone.purchases.documents.invoices.java.PurchaseInvoiceFromDelivNotesVO;
import org.jallinone.purchases.documents.java.DetailPurchaseDocRowVO;
import org.jallinone.purchases.documents.java.DetailPurchaseDocVO;
import org.jallinone.purchases.documents.java.PurchaseDocPK;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class PurchaseInvoiceDocFromDelivNotesController
extends CompanyFormController {
    private PurchaseInvoiceDocFromDelivNotesFrame frame = null;
    private PurchaseInvoiceDocsFrame parentFrame = null;
    private PurchaseDocPK pk = null;

    public PurchaseInvoiceDocFromDelivNotesController(PurchaseInvoiceDocsFrame parentFrame, PurchaseDocPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new PurchaseInvoiceDocFromDelivNotesFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        this.frame.getRowsPanel().setParentVO(vo);
        this.frame.getRowsPanel().getGrid().getOtherGridParams().put("PURCHASE_DOC_PK", this.pk);
        this.frame.getRowsPanel().getGrid().reloadData();
        this.frame.getDelivPanel().getGrid().getOtherGridParams().put("PURCHASE_DOC_VO", vo);
        this.frame.getDelivPanel().getGrid().setMode(0);
        this.frame.getDelivPanel().getGrid().clearData();
        this.frame.setButtonsEnabled(true);
        this.frame.enabledConfirmButton();
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC06().equals("D");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC06().equals("D");
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.getRowsPanel().getDetailPanel().getVOModel().setValueObject((ValueObject)new DetailPurchaseDocRowVO());
            this.frame.getRowsPanel().getDetailPanel().pull();
            this.frame.getDelivPanel().getGrid().clearData();
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)persistentObject;
        Calendar cal = Calendar.getInstance();
        vo.setDocYearDOC06(new BigDecimal((double)cal.get(1)));
        vo.setDocDateDOC06(new Date(System.currentTimeMillis()));
        vo.setDocTypeDOC06("L");
        vo.setDocStateDOC06("O");
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<PurchaseDocPK> pks = new ArrayList<PurchaseDocPK>();
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deletePurchaseDocs", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.getDelivPanel().getGrid().clearData();
        }
        return res;
    }

    public PurchaseInvoiceDocsFrame getParentFrame() {
        return this.parentFrame;
    }

    public PurchaseDocPK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        this.frame.getDelivPanel().getGrid().transferFocus();
        ArrayList<InDeliveryNotesVO> rows = new ArrayList<InDeliveryNotesVO>();
        boolean ok = false;
        InDeliveryNotesVO delivVO = null;
        int i = 0;
        while (i < this.frame.getDelivPanel().getGrid().getVOListTableModel().getRowCount()) {
            delivVO = (InDeliveryNotesVO)this.frame.getDelivPanel().getGrid().getVOListTableModel().getObjectForRow(i);
            if (delivVO.getSelected().equals(Boolean.TRUE)) {
                ok = true;
                rows.add(delivVO);
            }
            ++i;
        }
        if (!ok) {
            return new ErrorResponse(ClientSettings.getInstance().getResources().getResource("you must select at least one delivery note"));
        }
        Response res = ClientUtils.getData((String)"createInvoiceFromInDelivNotes", (Object)new PurchaseInvoiceFromDelivNotesVO((DetailPurchaseDocVO)newPersistentObject, rows));
        if (!res.isError()) {
            DetailPurchaseDocVO vo = (DetailPurchaseDocVO)((Object)((VOResponse)res).getVo());
            this.pk = new PurchaseDocPK(vo.getCompanyCodeSys01DOC06(), vo.getDocTypeDOC06(), vo.getDocYearDOC06(), vo.getDocNumberDOC06());
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadPurchaseDoc", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public void modeChanged(int currentMode) {
        DetailPurchaseDocVO vo;
        if (currentMode == 1 && (vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject()).getWarehouseCodeWar01DOC06() != null) {
            this.frame.getWarePanel().getWareController().forceValidate();
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updatePurchaseDoc", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError() && this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        return res;
    }
}

