/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.suppliers.client;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.purchases.suppliers.client.SupplierDetailFrame;
import org.jallinone.purchases.suppliers.client.SuppliersGridFrame;
import org.jallinone.purchases.suppliers.java.DetailSupplierVO;
import org.jallinone.subjects.java.Subject;
import org.jallinone.subjects.java.SubjectPK;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.util.client.ClientUtils;

public class SupplierController
extends CompanyFormController
implements TreeController {
    private SupplierDetailFrame detailFrame = null;
    private SuppliersGridFrame gridFrame = null;
    private SubjectPK pk = null;

    public SupplierController(SuppliersGridFrame gridFrame, SubjectPK pk) {
        this.gridFrame = gridFrame;
        this.pk = pk;
        this.detailFrame = new SupplierDetailFrame(this);
        MDIFrame.add((InternalFrame)this.detailFrame, (boolean)true);
        this.detailFrame.setParentFrame(gridFrame);
        gridFrame.pushFrame(this.detailFrame);
        if (pk != null) {
            this.detailFrame.getCurrentForm().setMode(0);
            this.detailFrame.getCurrentForm().executeReload();
        } else {
            this.detailFrame.getCurrentForm().insert();
        }
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.detailFrame.getReferencesPanel().getGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
            this.detailFrame.getTreePanel().clearTree();
            this.detailFrame.getSupplierPricelistPanel().getGrid().clearData();
            this.detailFrame.getSupplierPricelistPanel().getPricesGrid().clearData();
            this.detailFrame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject PersistentObject) throws Exception {
        String code;
        DetailSupplierVO vo = (DetailSupplierVO)PersistentObject;
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        if (applet.getAuthorizations().isOneCompany()) {
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("PUR01");
            vo.setCompanyCodeSys01REG04(companiesList.get(0).toString());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01REG04());
        map.put("PARAM_CODE", "D");
        Response response = ClientUtils.getData((String)"loadUserParam", map);
        if (!response.isError()) {
            code = (String)((VOResponse)response).getVo();
            vo.setDebitAccountCodeAcc02PUR01(code);
            this.detailFrame.getControlDebitsCode().setValue((Object)code);
            this.detailFrame.getControlDebitsCode().getLookupController().forceValidate();
        }
        map.clear();
        map.put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01REG04());
        map.put("PARAM_CODE", "COSTS_ACCOUNT");
        response = ClientUtils.getData((String)"loadUserParam", map);
        if (!response.isError()) {
            code = (String)((VOResponse)response).getVo();
            vo.setCostsAccountCodeAcc02PUR01(code);
            this.detailFrame.getControlCostsCode().setValue((Object)code);
            this.detailFrame.getControlCostsCode().getLookupController().forceValidate();
        }
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<SubjectPK> list = new ArrayList<SubjectPK>();
        DetailSupplierVO vo = (DetailSupplierVO)persistentObject;
        list.add(new SubjectPK(vo.getCompanyCodeSys01REG04(), vo.getProgressiveREG04()));
        Response response = ClientUtils.getData((String)"deleteSuppliers", list);
        if (!response.isError()) {
            this.gridFrame.reloadData();
            this.detailFrame.getReferencesPanel().getGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
            this.detailFrame.getTreePanel().clearTree();
            this.detailFrame.getSupplierPricelistPanel().getGrid().clearData();
            this.detailFrame.getSupplierPricelistPanel().getPricesGrid().clearData();
        }
        return response;
    }

    public void doubleClick(DefaultMutableTreeNode node) {
    }

    public SuppliersGridFrame getGridFrame() {
        return this.gridFrame;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"insertSupplier", (Object)newPersistentObject);
        if (!response.isError()) {
            DetailSupplierVO vo = (DetailSupplierVO)((VOResponse)response).getVo();
            this.pk = new SubjectPK(vo.getCompanyCodeSys01REG04(), vo.getProgressiveREG04());
            this.detailFrame.getReferencesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01REG04(), this.pk.getProgressiveREG04()));
            this.detailFrame.getReferencesPanel().getGrid().reloadData();
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01REG04(), this.pk.getProgressiveREG04()));
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "S");
            this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
            this.detailFrame.getTreePanel().reloadTree();
            this.detailFrame.getSupplierPricelistPanel().init(vo);
            this.detailFrame.getSupplierPricelistPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01REG04());
            this.detailFrame.getSupplierPricelistPanel().getGrid().getOtherGridParams().put("PROGRESSIVE_REG04", vo.getProgressiveREG04());
            this.detailFrame.getSupplierPricelistPanel().getGrid().reloadData();
            this.detailFrame.setButtonsEnabled(true);
        }
        return response;
    }

    public void leftClick(DefaultMutableTreeNode node) {
        HierarchyLevelVO vo = (HierarchyLevelVO)((Object)node.getUserObject());
        HierarchyLevelVO root = (HierarchyLevelVO)((Object)((DefaultMutableTreeNode)node.getRoot()).getUserObject());
        this.detailFrame.getItemsGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02HIE01());
        this.detailFrame.getItemsGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
        this.detailFrame.getItemsGrid().getOtherGridParams().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
        this.detailFrame.getItemsGrid().getOtherGridParams().put("PROGRESSIVE_REG04", this.pk.getProgressiveREG04());
        this.detailFrame.getItemsGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01REG04());
        this.detailFrame.getItemDataLocator().getLookupValidationParameters().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01REG04());
        this.detailFrame.getItemDataLocator().getLookupValidationParameters().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02HIE01());
        this.detailFrame.getItemDataLocator().getLookupValidationParameters().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
        this.detailFrame.getItemDataLocator().getLookupValidationParameters().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
        this.detailFrame.getItemDataLocator().getLookupFrameParams().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01REG04());
        this.detailFrame.getItemDataLocator().getLookupFrameParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02HIE01());
        this.detailFrame.getItemDataLocator().getLookupFrameParams().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
        this.detailFrame.getItemDataLocator().getLookupFrameParams().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
        this.detailFrame.getItemsGrid().reloadData();
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.gridFrame.getGrid().getSelectedRow();
        if (row != -1) {
            Subject gridVO = (Subject)this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.pk = new SubjectPK(gridVO.getCompanyCodeSys01REG04(), gridVO.getProgressiveREG04());
        }
        return ClientUtils.getData((String)"loadSupplier", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        if (!error) {
            this.detailFrame.getReferencesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01REG04(), this.pk.getProgressiveREG04()));
            this.detailFrame.getReferencesPanel().getGrid().reloadData();
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01REG04(), this.pk.getProgressiveREG04()));
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "S");
            this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
            DetailSupplierVO vo = (DetailSupplierVO)this.detailFrame.getCurrentForm().getVOModel().getValueObject();
            this.detailFrame.getSupplierPricelistPanel().init(vo);
            this.detailFrame.getSupplierPricelistPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01REG04());
            this.detailFrame.getSupplierPricelistPanel().getGrid().getOtherGridParams().put("PROGRESSIVE_REG04", vo.getProgressiveREG04());
            this.detailFrame.getSupplierPricelistPanel().getGrid().reloadData();
            this.detailFrame.setButtonsEnabled(true);
        }
    }

    public boolean rightClick(DefaultMutableTreeNode node) {
        return true;
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateSupplier", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!response.isError()) {
            // empty if block
        }
        return response;
    }
}

