/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.registers.payments.client;

import java.util.ArrayList;
import org.jallinone.registers.payments.client.PaymentsGridFrame;
import org.jallinone.registers.payments.java.PaymentVO;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientUtils;

public class PaymentsController
extends GridController {
    private PaymentsGridFrame gridFrame = new PaymentsGridFrame(this);

    public PaymentsController() {
        MDIFrame.add((InternalFrame)this.gridFrame, (boolean)true);
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response res = ClientUtils.getData((String)"deletePayments", (Object)persistentObjects);
        if (!res.isError()) {
            this.gridFrame.getInstalmentsGrid().clearData();
        }
        return res;
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        PaymentVO vo = (PaymentVO)persistentObject;
        this.gridFrame.getInstalmentsGrid().getOtherGridParams().put("PAYMENT_CODE_REG10", vo.getPaymentCodeREG10());
        this.gridFrame.getInstalmentsGrid().reloadData();
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        PaymentVO vo = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (PaymentVO)((Object)newValueObjects.get(i));
            if (vo.getInstalmentNumberREG10().intValue() < 1) {
                return new ErrorResponse("you must define at least one instalment");
            }
            ++i;
        }
        Response res = ClientUtils.getData((String)"insertPayments", (Object)newValueObjects);
        if (!res.isError()) {
            this.doubleClick(0, (ValueObject)((VOListResponse)res).getRows().get(0));
        }
        return res;
    }

    public void loadDataCompleted(boolean error) {
        if (this.gridFrame.getGrid().getVOListTableModel().getRowCount() > 0) {
            this.doubleClick(0, this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(0));
        }
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updatePayments", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

