/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.registers.task.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CustomizedColumns;
import org.jallinone.registers.task.java.TaskVO;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;

public class TasksGridFrame
extends InternalFrame {
    LookupController actController;
    LookupServerDataLocator actDataLocator;
    JPanel buttonsPanel = new JPanel();
    CodLookupColumn colActCode;
    TextColumn colActDescr;
    ComboColumn colCompany;
    CodLookupColumn colCurrency;
    TextColumn colDescr;
    CheckBoxColumn colFiniteCap;
    TextColumn colTask;
    private LookupServerDataLocator currDataLocator;
    private LookupController currLookupController;
    DeleteButton deleteButton;
    EditButton editButton;
    ExportButton exportButton;
    FlowLayout flowLayout1 = new FlowLayout();
    GridControl grid;
    private ServerGridDataLocator gridDataLocator;
    InsertButton insertButton = new InsertButton();
    NavigatorBar navigatorBar;
    ReloadButton reloadButton = new ReloadButton();
    SaveButton saveButton;

    public TasksGridFrame(GridController controller) {
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.colTask = new TextColumn();
        this.colDescr = new TextColumn();
        this.exportButton = new ExportButton();
        this.colCurrency = new CodLookupColumn();
        this.colFiniteCap = new CheckBoxColumn();
        this.colActCode = new CodLookupColumn();
        this.colActDescr = new TextColumn();
        this.gridDataLocator = new ServerGridDataLocator();
        this.currLookupController = new LookupController();
        this.currDataLocator = new LookupServerDataLocator();
        this.actController = new LookupController();
        this.actDataLocator = new LookupServerDataLocator();
        this.colCompany = new ComboColumn();
        this.grid.setController(controller);
        this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
        this.gridDataLocator.setServerMethodName("loadTasks");
        try {
            this.jbInit();
            this.setSize(750, 400);
            this.setMinimumSize(new Dimension(750, 400));
            this.colCurrency.setLookupController(this.currLookupController);
            this.colCurrency.setControllerMethodName("getCurrenciesList");
            this.currLookupController.setLookupDataLocator((LookupDataLocator)this.currDataLocator);
            this.currDataLocator.setGridMethodName("loadCurrencies");
            this.currDataLocator.setValidationMethodName("validateCurrencyCode");
            this.currLookupController.setAllColumnVisible(true);
            this.currLookupController.setFrameTitle("currencies");
            this.currLookupController.setLookupValueObjectClassName("org.jallinone.registers.currency.java.CurrencyVO");
            this.currLookupController.addLookup2ParentLink("currencyCodeREG03", "currencyCodeReg03REG07");
            this.currLookupController.setAllColumnVisible(false);
            this.currLookupController.setVisibleColumn("currencyCodeREG03", true);
            this.currLookupController.setVisibleColumn("currencySymbolREG03", true);
            this.currLookupController.setVisibleColumn("decimalSymbolREG03", true);
            this.currLookupController.setVisibleColumn("thousandSymbolREG03", true);
            CustomizedColumns currCust = new CustomizedColumns(new BigDecimal(182.0), this.currLookupController);
            CustomizedColumns cust = new CustomizedColumns(new BigDecimal(192.0), this.grid);
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("REG07");
            Domain domain = new Domain("DOMAIN_REG07");
            int i = 0;
            while (i < companiesList.size()) {
                if (applet.getAuthorizations().getCompanyBa().isInsertEnabled("REG07", companiesList.get(i).toString())) {
                    domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
                }
                ++i;
            }
            this.colCompany.setDomain(domain);
            this.actDataLocator.setGridMethodName("loadSaleActivities");
            this.actDataLocator.setValidationMethodName("validateSaleActivityCode");
            this.colActCode.setLookupController(this.actController);
            this.colActCode.setControllerMethodName("getSalesActivitiesList");
            this.actController.setLookupDataLocator((LookupDataLocator)this.actDataLocator);
            this.actController.setFrameTitle("sale activities");
            this.actController.setLookupValueObjectClassName("org.jallinone.sales.activities.java.SaleActivityVO");
            this.actController.addLookup2ParentLink("activityCodeSAL09", "activityCodeSal09REG07");
            this.actController.addLookup2ParentLink("descriptionSYS10", "activityDescriptionREG07");
            this.actController.setAllColumnVisible(false);
            this.actController.setVisibleColumn("activityCodeSAL09", true);
            this.actController.setVisibleColumn("descriptionSYS10", true);
            this.actController.setPreferredWidthColumn("descriptionSYS10", 200);
            this.actController.setFramePreferedSize(new Dimension(340, 400));
            this.actController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    TaskVO vo = (TaskVO)parentVO;
                    TasksGridFrame.this.actDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01REG07());
                    TasksGridFrame.this.actDataLocator.getLookupValidationParameters().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01REG07());
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.grid.setSelectionMode(2);
        this.saveButton.setExecuteAsThread(true);
        this.grid.setValueObjectClassName("org.jallinone.registers.task.java.TaskVO");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("tasks"));
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.grid.setDeleteButton(this.deleteButton);
        this.grid.setEditButton(this.editButton);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("REG07");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton);
        this.colTask.setMaxCharacters(20);
        this.colTask.setTrimText(true);
        this.colTask.setUpperCase(true);
        this.colTask.setColumnFilterable(true);
        this.colTask.setColumnName("taskCodeREG07");
        this.colTask.setColumnSortable(true);
        this.colTask.setEditableOnInsert(true);
        this.colTask.setSortVersus("ASC");
        this.colTask.setSortingOrder(1);
        this.colDescr.setColumnFilterable(false);
        this.colDescr.setColumnName("descriptionSYS10");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setEditableOnEdit(true);
        this.colDescr.setEditableOnInsert(true);
        this.colDescr.setHeaderColumnName("taskDescription");
        this.colDescr.setPreferredWidth(240);
        this.colCurrency.setColumnDuplicable(true);
        this.colCurrency.setColumnFilterable(true);
        this.colCurrency.setColumnName("currencyCodeReg03REG07");
        this.colCurrency.setColumnSortable(true);
        this.colCurrency.setEditableOnEdit(true);
        this.colCurrency.setEditableOnInsert(true);
        this.colCurrency.setMaxCharacters(20);
        this.colActCode.setColumnDuplicable(true);
        this.colActCode.setColumnFilterable(true);
        this.colActCode.setColumnName("activityCodeSal09REG07");
        this.colActCode.setColumnSortable(true);
        this.colActCode.setEditableOnEdit(true);
        this.colActCode.setEditableOnInsert(true);
        this.colActCode.setMaxCharacters(20);
        this.colActDescr.setColumnDuplicable(true);
        this.colActDescr.setColumnFilterable(true);
        this.colActDescr.setColumnName("activityDescriptionREG07");
        this.colActDescr.setColumnSortable(true);
        this.colActDescr.setEditableOnEdit(false);
        this.colActDescr.setEditableOnInsert(false);
        this.colActDescr.setPreferredWidth(200);
        this.colCompany.setColumnDuplicable(true);
        this.colCompany.setColumnFilterable(true);
        this.colCompany.setColumnName("companyCodeSys01REG07");
        this.colCompany.setColumnSortable(true);
        this.colCompany.setEditableOnEdit(false);
        this.colCompany.setEditableOnInsert(true);
        this.colCompany.setColumnRequired(true);
        this.colFiniteCap.setColumnFilterable(true);
        this.colFiniteCap.setColumnName("finiteCapacityREG07");
        this.colFiniteCap.setColumnRequired(false);
        this.colFiniteCap.setColumnSortable(true);
        this.colFiniteCap.setEditableOnEdit(true);
        this.colFiniteCap.setEditableOnInsert(true);
        this.colFiniteCap.setPreferredWidth(60);
        this.getContentPane().add((Component)this.buttonsPanel, "North");
        this.buttonsPanel.add((Component)this.insertButton, null);
        this.buttonsPanel.add((Component)this.editButton, null);
        this.buttonsPanel.add((Component)this.saveButton, null);
        this.buttonsPanel.add((Component)this.reloadButton, null);
        this.buttonsPanel.add((Component)this.deleteButton, null);
        this.buttonsPanel.add((Component)this.exportButton, null);
        this.buttonsPanel.add((Component)this.navigatorBar, null);
        this.getContentPane().add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)this.colCompany, null);
        this.grid.getColumnContainer().add((Component)this.colTask, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.grid.getColumnContainer().add((Component)this.colCurrency, null);
        this.grid.getColumnContainer().add((Component)this.colActCode, null);
        this.grid.getColumnContainer().add((Component)this.colActDescr, null);
        this.grid.getColumnContainer().add((Component)this.colFiniteCap, null);
    }

    public final void reloadData() {
        this.grid.reloadData();
    }
}

