/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.customers.client;

import java.util.ArrayList;
import java.util.HashMap;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.sales.customers.client.CustomerDetailFrame;
import org.jallinone.sales.customers.client.CustomersGridFrame;
import org.jallinone.sales.customers.java.CustomerPK;
import org.jallinone.subjects.java.Subject;
import org.jallinone.subjects.java.SubjectPK;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class CustomerController
extends CompanyFormController {
    private CustomerDetailFrame detailFrame = null;
    private CustomersGridFrame gridFrame = null;
    private CustomerPK pk = null;

    public CustomerController(CustomersGridFrame gridFrame, CustomerPK pk) {
        this.gridFrame = gridFrame;
        this.pk = pk;
        this.detailFrame = new CustomerDetailFrame(this);
        MDIFrame.add((InternalFrame)this.detailFrame);
        this.detailFrame.setParentFrame(gridFrame);
        gridFrame.pushFrame(this.detailFrame);
        if (pk != null) {
            this.detailFrame.subjectChanged(pk.getSubjectTypeREG04());
            this.detailFrame.getCurrentForm().setMode(0);
            this.detailFrame.getCurrentForm().executeReload();
        } else {
            this.detailFrame.getCurrentForm().insert();
        }
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.detailFrame.getReferencesPanel().getGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
            this.detailFrame.getDiscountsGrid().clearData();
            this.detailFrame.getDestGrid().clearData();
            this.detailFrame.getActivitiesGrid().clearData();
            this.detailFrame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject PersistentObject) throws Exception {
        String code;
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        String companyCode = null;
        if (applet.getAuthorizations().isOneCompany()) {
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("SAL07");
            companyCode = companiesList.get(0).toString();
            ((Subject)PersistentObject).setCompanyCodeSys01REG04(companyCode);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("COMPANY_CODE_SYS01", companyCode);
        map.put("PARAM_CODE", "CREDITS_ACCOUNT");
        Response response = ClientUtils.getData((String)"loadUserParam", map);
        if (!response.isError()) {
            code = (String)((VOResponse)response).getVo();
            this.detailFrame.getControlCreditsCode().setValue((Object)code);
            this.detailFrame.getControlCreditsCode().getLookupController().forceValidate();
        }
        map.clear();
        map.put("COMPANY_CODE_SYS01", companyCode);
        map.put("PARAM_CODE", "ITEMS_ACCOUNT");
        response = ClientUtils.getData((String)"loadUserParam", map);
        if (!response.isError()) {
            code = (String)((VOResponse)response).getVo();
            this.detailFrame.getControlItemsCode().setValue((Object)code);
            this.detailFrame.getControlItemsCode().getLookupController().forceValidate();
        }
        map.clear();
        map.put("COMPANY_CODE_SYS01", companyCode);
        map.put("PARAM_CODE", "ACTIVITIES_ACCOUNT");
        response = ClientUtils.getData((String)"loadUserParam", map);
        if (!response.isError()) {
            code = (String)((VOResponse)response).getVo();
            this.detailFrame.getControlActCode().setValue((Object)code);
            this.detailFrame.getControlActCode().getLookupController().forceValidate();
        }
        map.clear();
        map.put("COMPANY_CODE_SYS01", companyCode);
        map.put("PARAM_CODE", "CHARGES_ACCOUNT");
        response = ClientUtils.getData((String)"loadUserParam", map);
        if (!response.isError()) {
            code = (String)((VOResponse)response).getVo();
            this.detailFrame.getControlChargesCode().setValue((Object)code);
            this.detailFrame.getControlChargesCode().getLookupController().forceValidate();
        }
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<ValueObject> list = new ArrayList<ValueObject>();
        list.add(persistentObject);
        Response response = ClientUtils.getData((String)"deleteCustomers", list);
        if (!response.isError()) {
            this.gridFrame.reloadData();
            this.detailFrame.getReferencesPanel().getGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
            this.detailFrame.getDiscountsGrid().clearData();
            this.detailFrame.getDestGrid().clearData();
            this.detailFrame.getActivitiesGrid().clearData();
        }
        return response;
    }

    public CustomersGridFrame getGridFrame() {
        return this.gridFrame;
    }

    public CustomerPK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        ((Subject)newPersistentObject).setSubjectTypeREG04((String)this.detailFrame.getControlSubjectType().getValue());
        Response response = ClientUtils.getData((String)"insertCustomer", (Object)newPersistentObject);
        if (!response.isError()) {
            Subject sub = (Subject)((VOResponse)response).getVo();
            this.pk = new CustomerPK(sub.getCompanyCodeSys01REG04(), sub.getProgressiveREG04(), sub.getSubjectTypeREG04());
            this.detailFrame.getReferencesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01SAL07(), this.pk.getProgressiveReg04SAL07()));
            this.detailFrame.getReferencesPanel().getGrid().reloadData();
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01SAL07(), this.pk.getProgressiveReg04SAL07()));
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "C");
            this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
            this.detailFrame.getDiscountsGrid().getOtherGridParams().put("SUBJECT_PK", this.pk);
            this.detailFrame.getDiscountsGrid().reloadData();
            this.detailFrame.getDestGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01SAL07(), this.pk.getProgressiveReg04SAL07()));
            this.detailFrame.getDestGrid().reloadData();
            this.detailFrame.getActivitiesGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01SAL07());
            this.detailFrame.getActivitiesGrid().getOtherGridParams().put("PROGRESSIVE_REG04_SUBJECT", this.pk.getProgressiveReg04SAL07());
            this.detailFrame.getActivitiesGrid().reloadData();
            this.detailFrame.setButtonsEnabled(true);
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.gridFrame.getGrid().getSelectedRow();
        if (row != -1) {
            Subject gridVO = (Subject)this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.pk = new CustomerPK(gridVO.getCompanyCodeSys01REG04(), gridVO.getProgressiveREG04(), gridVO.getSubjectTypeREG04());
        }
        this.detailFrame.subjectChanged(this.pk.getSubjectTypeREG04());
        return ClientUtils.getData((String)"loadCustomer", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.detailFrame.getReferencesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01SAL07(), this.pk.getProgressiveReg04SAL07()));
        this.detailFrame.getReferencesPanel().getGrid().reloadData();
        this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01SAL07(), this.pk.getProgressiveReg04SAL07()));
        this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "C");
        this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
        this.detailFrame.getDiscountsGrid().getOtherGridParams().put("SUBJECT_PK", this.pk);
        this.detailFrame.getDiscountsGrid().reloadData();
        this.detailFrame.getDestGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(this.pk.getCompanyCodeSys01SAL07(), this.pk.getProgressiveReg04SAL07()));
        this.detailFrame.getDestGrid().reloadData();
        this.detailFrame.getAgentDataLocator().getLookupValidationParameters().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01SAL07());
        this.detailFrame.getAgentDataLocator().getLookupFrameParams().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01SAL07());
        this.detailFrame.getActivitiesGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.pk.getCompanyCodeSys01SAL07());
        this.detailFrame.getActivitiesGrid().getOtherGridParams().put("PROGRESSIVE_REG04_SUBJECT", this.pk.getProgressiveReg04SAL07());
        this.detailFrame.getActivitiesGrid().reloadData();
        this.detailFrame.setButtonsEnabled(true);
    }

    public void modeChanged(int currentMode) {
        if (currentMode == 1) {
            this.detailFrame.getControlSubjectType().setEnabled(true);
            this.detailFrame.getControlSubjectType().getComboBox().setSelectedIndex(0);
        } else if (currentMode == 2 || currentMode == 0) {
            this.detailFrame.getControlSubjectType().setEnabled(false);
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateCustomer", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!response.isError()) {
            // empty if block
        }
        return response;
    }
}

