/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jallinone.sales.customers.java.CustomerPK;
import org.jallinone.sales.customers.java.OrganizationCustomerVO;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class SaleCustomerHeadPanel
extends JPanel {
    TextControl controlCurrency;
    CodLookupControl controlCustomerCode;
    TextControl controlName1;
    TextControl controlName2;
    TextControl controlPayDescr;
    CodLookupControl controlPaymentCode;
    CodLookupControl controlPricelistCode;
    TextControl controlPricelistDescr;
    LookupController customerController;
    LookupServerDataLocator customerDataLocator;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    LabelControl labelCurrency;
    LabelControl labelCustomer = new LabelControl();
    LabelControl labelPayment;
    LabelControl labelPricelist;
    LookupController payController;
    LookupServerDataLocator payDataLocator;
    LookupController pricelistController;
    LookupServerDataLocator pricelistDataLocator;
    TitledBorder titledBorder1;

    public SaleCustomerHeadPanel(final Form form) {
        this.controlCustomerCode = new CodLookupControl();
        this.controlName1 = new TextControl();
        this.labelPricelist = new LabelControl();
        this.controlPricelistCode = new CodLookupControl();
        this.controlPricelistDescr = new TextControl();
        this.labelCurrency = new LabelControl();
        this.controlCurrency = new TextControl();
        this.labelPayment = new LabelControl();
        this.controlPaymentCode = new CodLookupControl();
        this.controlPayDescr = new TextControl();
        this.customerController = new LookupController();
        this.customerDataLocator = new LookupServerDataLocator();
        this.pricelistController = new LookupController();
        this.pricelistDataLocator = new LookupServerDataLocator();
        this.payController = new LookupController();
        this.payDataLocator = new LookupServerDataLocator();
        this.controlName2 = new TextControl();
        try {
            this.jbInit();
            this.customerDataLocator.setGridMethodName("loadCustomers");
            this.customerDataLocator.setValidationMethodName("validateCustomerCode");
            this.controlCustomerCode.setLookupController(this.customerController);
            this.controlCustomerCode.setControllerMethodName("getCustomersList");
            this.customerController.setForm(form);
            this.customerController.setLookupDataLocator((LookupDataLocator)this.customerDataLocator);
            this.customerController.setFrameTitle("customers");
            this.customerController.setLookupValueObjectClassName("org.jallinone.sales.customers.java.GridCustomerVO");
            this.customerController.addLookup2ParentLink("companyCodeSys01REG04", "companyCodeSys01DOC01");
            this.customerController.addLookup2ParentLink("customerCodeSAL07", "customerCodeSAL07");
            this.customerController.addLookup2ParentLink("progressiveREG04", "progressiveReg04DOC01");
            this.customerController.addLookup2ParentLink("name_1REG04", "name_1REG04");
            this.customerController.addLookup2ParentLink("name_2REG04", "name_2REG04");
            this.customerController.addLookup2ParentLink("paymentCodeReg10SAL07", "paymentCodeReg10DOC01");
            this.customerController.addLookup2ParentLink("paymentDescriptionSAL07", "paymentDescriptionDOC01");
            this.customerController.addLookup2ParentLink("vatCodeReg01SAL07", "customerVatCodeReg01DOC01");
            this.customerController.setAllColumnVisible(false);
            this.customerController.setVisibleColumn("companyCodeSys01REG04", true);
            this.customerController.setFilterableColumn("companyCodeSys01REG04", true);
            this.customerController.setFilterableColumn("customerCodeSAL07", true);
            this.customerController.setFilterableColumn("name_1REG04", true);
            this.customerController.setFilterableColumn("name_2REG04", true);
            this.customerController.setFilterableColumn("cityREG04", true);
            this.customerController.setFilterableColumn("provinceREG04", true);
            this.customerController.setSortableColumn("companyCodeSys01REG04", true);
            this.customerController.setSortableColumn("customerCodeSAL07", true);
            this.customerController.setSortableColumn("name_1REG04", true);
            this.customerController.setSortableColumn("name_2REG04", true);
            this.customerController.setSortableColumn("cityREG04", true);
            this.customerController.setSortableColumn("provinceREG04", true);
            this.customerController.setVisibleColumn("customerCodeSAL07", true);
            this.customerController.setVisibleColumn("name_1REG04", true);
            this.customerController.setVisibleColumn("name_2REG04", true);
            this.customerController.setVisibleColumn("cityREG04", true);
            this.customerController.setVisibleColumn("provinceREG04", true);
            this.customerController.setVisibleColumn("countryREG04", true);
            this.customerController.setVisibleColumn("taxCodeREG04", true);
            this.customerController.setHeaderColumnName("cityREG04", "city");
            this.customerController.setHeaderColumnName("provinceREG04", "prov");
            this.customerController.setHeaderColumnName("countryREG04", "country");
            this.customerController.setHeaderColumnName("taxCodeREG04", "taxCode");
            this.customerController.setPreferredWidthColumn("name_1REG04", 200);
            this.customerController.setPreferredWidthColumn("name_2REG04", 150);
            this.customerController.setFramePreferedSize(new Dimension(750, 500));
            this.customerDataLocator.getLookupFrameParams().put("FILTER_COMPANY_FOR_INSERT", "DOC01_ORDERS");
            this.customerDataLocator.getLookupValidationParameters().put("FILTER_COMPANY_FOR_INSERT", "DOC01_ORDERS");
            this.customerController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    if (SaleCustomerHeadPanel.this.customerDataLocator.getLookupFrameParams().get("SUBJECT_TYPE") == null) {
                        return;
                    }
                    if (SaleCustomerHeadPanel.this.customerDataLocator.getLookupFrameParams().get("SUBJECT_TYPE").equals("C")) {
                        SaleCustomerHeadPanel.this.customerController.setHeaderColumnName("name_1REG04", "corporateName1");
                        SaleCustomerHeadPanel.this.customerController.setHeaderColumnName("name_2REG04", "corporateName2");
                    } else if (SaleCustomerHeadPanel.this.customerDataLocator.getLookupFrameParams().get("SUBJECT_TYPE").equals("P")) {
                        SaleCustomerHeadPanel.this.customerController.setHeaderColumnName("name_1REG04", "firstname");
                        SaleCustomerHeadPanel.this.customerController.setHeaderColumnName("name_2REG04", "lastname");
                    }
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    DetailSaleDocVO vo = (DetailSaleDocVO)form.getVOModel().getValueObject();
                    if (vo.getCustomerCodeSAL07() == null || vo.getCustomerCodeSAL07().equals("")) {
                        vo.setPricelistCodeSal01DOC01(null);
                        vo.setPricelistDescriptionDOC01(null);
                        vo.setCurrencyCodeReg03DOC01(null);
                    } else {
                        OrganizationCustomerVO custVO;
                        Response res = ClientUtils.getData((String)"loadCustomer", (Object)new CustomerPK(vo.getCompanyCodeSys01DOC01(), vo.getProgressiveReg04DOC01(), "C"));
                        if (!res.isError() && (custVO = (OrganizationCustomerVO)((VOResponse)res).getVo()).getPricelistCodeSal01SAL07() != null) {
                            SaleCustomerHeadPanel.this.controlPricelistCode.setValue((Object)custVO.getPricelistCodeSal01SAL07());
                            SaleCustomerHeadPanel.this.pricelistController.forceValidate();
                        }
                    }
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.pricelistDataLocator.setGridMethodName("loadPricelists");
            this.pricelistDataLocator.setValidationMethodName("validatePricelistCode");
            this.controlPricelistCode.setLookupController(this.pricelistController);
            this.controlPricelistCode.setControllerMethodName("getSalePricesList");
            this.pricelistController.setLookupDataLocator((LookupDataLocator)this.pricelistDataLocator);
            this.pricelistController.setForm(form);
            this.pricelistController.setFrameTitle("pricelists");
            this.pricelistController.setLookupValueObjectClassName("org.jallinone.sales.pricelist.java.PricelistVO");
            this.pricelistController.addLookup2ParentLink("pricelistCodeSAL01", "pricelistCodeSal01DOC01");
            this.pricelistController.addLookup2ParentLink("descriptionSYS10", "pricelistDescriptionDOC01");
            this.pricelistController.addLookup2ParentLink("currencyCodeReg03SAL01", "currencyCodeReg03DOC01");
            this.pricelistController.setAllColumnVisible(false);
            this.pricelistController.setVisibleColumn("pricelistCodeSAL01", true);
            this.pricelistController.setVisibleColumn("descriptionSYS10", true);
            this.pricelistController.setVisibleColumn("currencyCodeReg03SAL01", true);
            this.pricelistController.setPreferredWidthColumn("descriptionSYS10", 250);
            this.pricelistController.setFramePreferedSize(new Dimension(420, 500));
            this.pricelistController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    DetailSaleDocVO vo = (DetailSaleDocVO)form.getVOModel().getValueObject();
                    SaleCustomerHeadPanel.this.pricelistDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01DOC01());
                    SaleCustomerHeadPanel.this.pricelistDataLocator.getLookupFrameParams().put("PROGRESSIVE_REG04", vo.getProgressiveReg04DOC01());
                    SaleCustomerHeadPanel.this.pricelistDataLocator.getLookupValidationParameters().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01DOC01());
                    SaleCustomerHeadPanel.this.pricelistDataLocator.getLookupValidationParameters().put("PROGRESSIVE_REG04", vo.getProgressiveReg04DOC01());
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.payDataLocator.setGridMethodName("loadPayments");
            this.payDataLocator.setValidationMethodName("validatePaymentCode");
            this.controlPaymentCode.setLookupController(this.payController);
            this.controlPaymentCode.setControllerMethodName("getPaymentsList");
            this.payController.setForm(form);
            this.payController.setLookupDataLocator((LookupDataLocator)this.payDataLocator);
            this.payController.setFrameTitle("payments");
            this.payController.setLookupValueObjectClassName("org.jallinone.registers.payments.java.PaymentVO");
            this.payController.addLookup2ParentLink("paymentCodeREG10", "paymentCodeReg10DOC01");
            this.payController.addLookup2ParentLink("descriptionSYS10", "paymentDescriptionDOC01");
            this.payController.setAllColumnVisible(false);
            this.payController.setVisibleColumn("paymentCodeREG10", true);
            this.payController.setVisibleColumn("descriptionSYS10", true);
            this.pricelistController.setPreferredWidthColumn("descriptionSYS10", 250);
            this.pricelistController.setFramePreferedSize(new Dimension(350, 500));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LookupController getCustomerController() {
        return this.customerController;
    }

    public LookupServerDataLocator getCustomerDataLocator() {
        return this.customerDataLocator;
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.labelCustomer.setText("customer");
        this.titledBorder1.setTitle(ClientSettings.getInstance().getResources().getResource("customer data"));
        this.titledBorder1.setBorder(BorderFactory.createEtchedBorder());
        this.titledBorder1.setTitleColor(Color.blue);
        this.setBorder(this.titledBorder1);
        this.setLayout(this.gridBagLayout1);
        this.controlCustomerCode.setCanCopy(true);
        this.controlCustomerCode.setLinkLabel(this.labelCustomer);
        this.controlCustomerCode.setMaxCharacters(20);
        this.controlCustomerCode.setRequired(true);
        this.controlCustomerCode.setAttributeName("customerCodeSAL07");
        this.labelPricelist.setText("pricelist");
        this.labelCurrency.setText("currencyCodeREG03");
        this.labelPayment.setText("payment terms");
        this.controlName1.setCanCopy(true);
        this.controlName1.setEnabledOnInsert(false);
        this.controlName1.setEnabledOnEdit(false);
        this.controlName1.setAttributeName("name_1REG04");
        this.controlPricelistCode.setCanCopy(true);
        this.controlPricelistCode.setLinkLabel(this.labelPricelist);
        this.controlPricelistCode.setMaxCharacters(20);
        this.controlPricelistCode.setRequired(true);
        this.controlPricelistCode.setAttributeName("pricelistCodeSal01DOC01");
        this.controlPaymentCode.setCanCopy(true);
        this.controlPaymentCode.setLinkLabel(this.labelPayment);
        this.controlPaymentCode.setMaxCharacters(20);
        this.controlPaymentCode.setRequired(true);
        this.controlPaymentCode.setAttributeName("paymentCodeReg10DOC01");
        this.controlCurrency.setCanCopy(true);
        this.controlCurrency.setEnabledOnInsert(false);
        this.controlCurrency.setEnabledOnEdit(false);
        this.controlCurrency.setAttributeName("currencyCodeReg03DOC01");
        this.controlPricelistDescr.setEnabledOnInsert(false);
        this.controlPricelistDescr.setEnabledOnEdit(false);
        this.controlPricelistDescr.setAttributeName("pricelistDescriptionDOC01");
        this.controlPayDescr.setEnabledOnInsert(false);
        this.controlPayDescr.setEnabledOnEdit(false);
        this.controlPayDescr.setAttributeName("paymentDescriptionDOC01");
        this.controlName2.setEnabledOnInsert(false);
        this.controlName2.setEnabledOnEdit(false);
        this.controlName2.setAttributeName("name_2REG04");
        this.add((Component)this.labelCustomer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlCustomerCode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 70, 0));
        this.add((Component)this.labelPayment, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlName1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 200, 0));
        this.add((Component)this.labelPricelist, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlPricelistCode, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 70, 0));
        this.add((Component)this.controlPricelistDescr, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlPaymentCode, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 70, 0));
        this.add((Component)this.controlPayDescr, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelCurrency, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlCurrency, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 70, 0));
        this.add((Component)this.controlName2, new GridBagConstraints(3, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }
}

