/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.sales.documents.client.SaleDeskDocFrame;
import org.jallinone.sales.documents.client.SaleDeskDocsFrame;
import org.jallinone.sales.documents.java.DetailSaleDocRowVO;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.jallinone.sales.documents.java.GridSaleDocVO;
import org.jallinone.sales.documents.java.SaleDocPK;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class SaleDeskDocController
extends CompanyFormController {
    private SaleDeskDocFrame frame = null;
    private SaleDeskDocsFrame parentFrame = null;
    private SaleDocPK pk = null;

    public SaleDeskDocController(SaleDeskDocsFrame parentFrame, SaleDocPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new SaleDeskDocFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            // empty if block
        }
        DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        this.frame.getRowsPanel().setParentVO(vo);
        this.frame.getRowsPanel().getGrid().getOtherGridParams().put("SALE_DOC_PK", this.pk);
        this.frame.getRowsPanel().getGrid().reloadData();
        this.frame.setButtonsEnabled(true);
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC01().equals("D");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC01().equals("D");
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.getRowsPanel().getDetailPanel().getVOModel().setValueObject((ValueObject)new DetailSaleDocRowVO());
            this.frame.getRowsPanel().getDetailPanel().pull();
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailSaleDocVO vo = (DetailSaleDocVO)persistentObject;
        Calendar cal = Calendar.getInstance();
        vo.setDocYearDOC01(new BigDecimal((double)cal.get(1)));
        vo.setDocDateDOC01(new Date(System.currentTimeMillis()));
        vo.setDocTypeDOC01("D");
        vo.setDocStateDOC01("O");
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList("DOC01_DESKSALES");
        if (companiesList.size() > 0) {
            String warCode;
            String customerCode;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("COMPANY_CODE_SYS01", companiesList.get(0));
            map.put("PARAM_CODE", "CUSTOMER_CODE");
            Response res = ClientUtils.getData((String)"loadUserParam", map);
            if (!res.isError() && (customerCode = (String)((VOResponse)res).getVo()) != null) {
                vo.setCustomerCodeSAL07(customerCode);
                vo.setCompanyCodeSys01DOC01(companiesList.get(0).toString());
            }
            map.put("COMPANY_CODE_SYS01", companiesList.get(0));
            map.put("PARAM_CODE", "WAREHOUSE_CODE");
            res = ClientUtils.getData((String)"loadUserParam", map);
            if (!res.isError() && (warCode = (String)((VOResponse)res).getVo()) != null) {
                vo.setWarehouseCodeWar01DOC01(warCode);
            }
        }
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<SaleDocPK> pks = new ArrayList<SaleDocPK>();
        DetailSaleDocVO vo = (DetailSaleDocVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deleteSaleDocs", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getRowsPanel().getGrid().clearData();
        }
        return res;
    }

    public SaleDeskDocsFrame getParentFrame() {
        return this.parentFrame;
    }

    public SaleDocPK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"insertSaleDoc", (Object)newPersistentObject);
        if (!res.isError()) {
            DetailSaleDocVO vo = (DetailSaleDocVO)((Object)((VOResponse)res).getVo());
            this.pk = new SaleDocPK(vo.getCompanyCodeSys01DOC01(), vo.getDocTypeDOC01(), vo.getDocYearDOC01(), vo.getDocNumberDOC01());
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.parentFrame.getGrid().getSelectedRow();
        if (row != -1) {
            GridSaleDocVO gridVO = (GridSaleDocVO)this.parentFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.pk = new SaleDocPK(gridVO.getCompanyCodeSys01DOC01(), gridVO.getDocTypeDOC01(), gridVO.getDocYearDOC01(), gridVO.getDocNumberDOC01());
        }
        return ClientUtils.getData((String)"loadSaleDoc", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public void modeChanged(int currentMode) {
        if (currentMode == 1) {
            DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
            if (vo.getCustomerCodeSAL07() != null) {
                this.frame.getSaleCustomerHeadPanel1().getCustomerController().forceValidate();
            }
            if (vo.getWarehouseCodeWar01DOC01() != null) {
                this.frame.getWareController().forceValidate();
            }
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateSaleDoc", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (res.isError() || this.parentFrame != null) {
            // empty if block
        }
        return res;
    }
}

