/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.client;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.sales.documents.client.SaleDeskDocRowsGridPanel;
import org.jallinone.sales.documents.java.DetailSaleDocRowVO;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.jallinone.sales.documents.java.SaleDocRowPK;
import org.jallinone.warehouse.documents.client.SerialNumberDialog;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class SaleDeskDocRowController
extends CompanyFormController {
    private SaleDeskDocRowsGridPanel panel = null;
    private SaleDocRowPK pk = null;

    public SaleDeskDocRowController(SaleDeskDocRowsGridPanel panel) {
        this.panel = panel;
    }

    public void afterInsertData() {
        this.panel.getGrid().reloadData();
        this.panel.getHeaderPanel().setMode(0);
        this.panel.getHeaderPanel().executeReload();
        this.panel.getDesks().reloadData();
        this.panel.getFrame().enabledConfirmButton();
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC01().equals("D");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC01().equals("D");
    }

    public boolean beforeInsertData(Form form) {
        if (!super.beforeInsertData(form)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC01().equals("D");
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailSaleDocRowVO vo = (DetailSaleDocRowVO)persistentObject;
        DetailSaleDocVO parentVO = this.panel.getParentVO();
        Calendar cal = Calendar.getInstance();
        vo.setCompanyCodeSys01DOC02(parentVO.getCompanyCodeSys01DOC01());
        vo.setDocYearDOC02(parentVO.getDocYearDOC01());
        vo.setDocTypeDOC02(parentVO.getDocTypeDOC01());
        vo.setDocNumberDOC02(parentVO.getDocNumberDOC01());
        vo.setDeliveryDateDOC02(new Date(System.currentTimeMillis()));
        vo.setCurrencyCodeReg03DOC01(this.panel.getParentVO().getCurrencyCodeReg03DOC01());
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<SaleDocRowPK> pks = new ArrayList<SaleDocRowPK>();
        DetailSaleDocRowVO vo = (DetailSaleDocRowVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deleteSaleDocRows", pks);
        if (!res.isError()) {
            this.panel.getGrid().reloadData();
            this.panel.getHeaderPanel().setMode(0);
            this.panel.getHeaderPanel().executeReload();
            this.panel.getDesks().reloadData();
        }
        return res;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        if (this.panel.isSerialNumberRequired() && !this.promptSerialNumbers((DetailSaleDocRowVO)newPersistentObject)) {
            return new ErrorResponse("insert not allowed until serial numbers are not defined");
        }
        Response res = ClientUtils.getData((String)"insertSaleDocRow", (Object)newPersistentObject);
        if (!res.isError()) {
            DetailSaleDocRowVO vo = (DetailSaleDocRowVO)((Object)((VOResponse)res).getVo());
            this.pk = new SaleDocRowPK(vo.getCompanyCodeSys01DOC02(), vo.getDocTypeDOC02(), vo.getDocYearDOC02(), vo.getDocNumberDOC02(), vo.getItemCodeItm01DOC02());
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        if (this.pk == null) {
            return new VOResponse((Object)new DetailSaleDocRowVO());
        }
        return ClientUtils.getData((String)"loadSaleDocRow", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        if (error) {
            return;
        }
        DetailSaleDocRowVO vo = (DetailSaleDocRowVO)this.panel.getDetailPanel().getVOModel().getValueObject();
        this.panel.getBookedItemsPanel().getControlItemType().setValue((Object)vo.getProgressiveHie02DOC02());
        this.panel.getBookedItemsPanel().getControlItemCode().setValue((Object)vo.getItemCodeItm01DOC02());
        this.panel.getBookedItemsPanel().getControlItemCode().getLookupController().forceValidate();
        this.panel.getBookedItemsPanel().getGrid().reloadData();
        this.panel.getOrderedItemsPanel().getControlItemType().setValue((Object)vo.getProgressiveHie02DOC02());
        this.panel.getOrderedItemsPanel().getControlItemCode().setValue((Object)vo.getItemCodeItm01DOC02());
        this.panel.getOrderedItemsPanel().getControlItemCode().getLookupController().forceValidate();
        this.panel.getOrderedItemsPanel().getGrid().reloadData();
    }

    private boolean promptSerialNumbers(DetailSaleDocRowVO vo) {
        ArrayList list = vo.getSerialNumbers();
        if (list == null) {
            list = new ArrayList(vo.getQtyDOC02().intValue());
            vo.setSerialNumbers(list);
            list = new ArrayList(vo.getQtyDOC02().intValue());
            vo.setBarCodes(list);
        } else if (vo.getSerialNumbers().size() < vo.getQtyDOC02().intValue()) {
            int i = vo.getSerialNumbers().size();
            while (i < vo.getQtyDOC02().intValue()) {
                vo.getSerialNumbers().add(null);
                vo.getBarCodes().add(null);
                ++i;
            }
        } else if (vo.getSerialNumbers().size() > vo.getQtyDOC02().intValue()) {
            while (vo.getSerialNumbers().size() > vo.getQtyDOC02().intValue()) {
                vo.getSerialNumbers().remove(vo.getSerialNumbers().size() - 1);
                vo.getBarCodes().remove(vo.getBarCodes().size() - 1);
            }
        }
        new SerialNumberDialog(vo.getSerialNumbers(), vo.getBarCodes(), vo.getItemCodeItm01DOC02() + " - " + vo.getDescriptionSYS10());
        return true;
    }

    public void setPk(SaleDocRowPK pk) {
        this.pk = pk;
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        if (this.panel.isSerialNumberRequired() && !this.promptSerialNumbers((DetailSaleDocRowVO)persistentObject)) {
            return new ErrorResponse("update not allowed until serial numbers are not defined");
        }
        Response res = ClientUtils.getData((String)"updateSaleDocRow", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError()) {
            this.panel.getGrid().reloadData();
            this.panel.getHeaderPanel().setMode(0);
            this.panel.getHeaderPanel().executeReload();
            this.panel.getDesks().reloadData();
        }
        return res;
    }
}

