/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.jallinone.subjects.java.SubjectPK;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;

public class SaleWarehousePanel
extends JPanel {
    TextControl controlAddress;
    TextControl controlCity;
    TextControl controlCountry;
    TextControl controlDescr;
    CodLookupControl controlDestCode;
    TextControl controlDestDescr;
    TextControl controlProv;
    CodLookupControl controlWarehouseCode;
    TextControl controlZip;
    LookupController destController;
    LookupServerDataLocator destDataLocator;
    private Form form = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    LabelControl labelAddress;
    LabelControl labelCity;
    LabelControl labelCountry;
    LabelControl labelDest;
    LabelControl labelProv;
    LabelControl labelWarehouseCode = new LabelControl();
    LabelControl labelZip;
    TitledBorder titledBorder1;
    LookupController wareController;
    LookupServerDataLocator wareDataLocator;

    public SaleWarehousePanel(final Form form) {
        this.controlWarehouseCode = new CodLookupControl();
        this.controlZip = new TextControl();
        this.controlProv = new TextControl();
        this.controlCity = new TextControl();
        this.controlAddress = new TextControl();
        this.labelAddress = new LabelControl();
        this.controlCountry = new TextControl();
        this.labelZip = new LabelControl();
        this.labelCity = new LabelControl();
        this.labelCountry = new LabelControl();
        this.labelProv = new LabelControl();
        this.controlDescr = new TextControl();
        this.wareController = new LookupController();
        this.wareDataLocator = new LookupServerDataLocator();
        this.destController = new LookupController();
        this.destDataLocator = new LookupServerDataLocator();
        this.labelDest = new LabelControl();
        this.controlDestCode = new CodLookupControl();
        this.controlDestDescr = new TextControl();
        this.form = form;
        try {
            this.jbInit();
            this.wareDataLocator.setGridMethodName("loadWarehouses");
            this.wareDataLocator.setValidationMethodName("validateWarehouseCode");
            this.controlWarehouseCode.setLookupController(this.wareController);
            this.controlWarehouseCode.setControllerMethodName("getWarehousesList");
            this.wareController.setForm(form);
            this.wareController.setLookupDataLocator((LookupDataLocator)this.wareDataLocator);
            this.wareController.setFrameTitle("warehouses");
            this.wareController.setLookupValueObjectClassName("org.jallinone.warehouse.java.WarehouseVO");
            this.wareController.addLookup2ParentLink("warehouseCodeWAR01", "warehouseCodeWar01DOC01");
            this.wareController.addLookup2ParentLink("descriptionWAR01", "descriptionWar01DOC01");
            this.wareController.setAllColumnVisible(false);
            this.wareController.setVisibleColumn("warehouseCodeWAR01", true);
            this.wareController.setVisibleColumn("descriptionWAR01", true);
            this.wareController.setVisibleColumn("addressWAR01", true);
            this.wareController.setVisibleColumn("cityWAR01", true);
            this.wareController.setVisibleColumn("zipWAR01", true);
            this.wareController.setVisibleColumn("provinceWAR01", true);
            this.wareController.setVisibleColumn("countryWAR01", true);
            this.wareController.setPreferredWidthColumn("descriptionWAR01", 200);
            this.wareController.setFramePreferedSize(new Dimension(750, 500));
            this.wareController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    DetailSaleDocVO vo = (DetailSaleDocVO)form.getVOModel().getValueObject();
                    SaleWarehousePanel.this.wareDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01DOC01());
                    SaleWarehousePanel.this.wareDataLocator.getLookupValidationParameters().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01DOC01());
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.destDataLocator.setGridMethodName("loadDestinations");
            this.destDataLocator.setValidationMethodName("validateDestinationCode");
            this.controlDestCode.setLookupController(this.destController);
            this.destController.setForm(form);
            this.destController.setLookupDataLocator((LookupDataLocator)this.destDataLocator);
            this.destController.setFrameTitle("destinations");
            this.destController.setLookupValueObjectClassName("org.jallinone.sales.destinations.java.DestinationVO");
            this.destController.addLookup2ParentLink("destinationCodeREG18", "destinationCodeReg18DOC01");
            this.destController.addLookup2ParentLink("descriptionREG18", "descriptionDOC01");
            this.destController.addLookup2ParentLink("addressREG18", "addressDOC01");
            this.destController.addLookup2ParentLink("cityREG18", "cityDOC01");
            this.destController.addLookup2ParentLink("zipREG18", "zipDOC01");
            this.destController.addLookup2ParentLink("provinceREG18", "provinceDOC01");
            this.destController.addLookup2ParentLink("countryREG18", "countryDOC01");
            this.destController.setAllColumnVisible(false);
            this.destController.setVisibleColumn("destinationCodeREG18", true);
            this.destController.setVisibleColumn("descriptionREG18", true);
            this.destController.setVisibleColumn("addressREG18", true);
            this.destController.setVisibleColumn("cityREG18", true);
            this.destController.setVisibleColumn("zipREG18", true);
            this.destController.setVisibleColumn("provinceREG18", true);
            this.destController.setVisibleColumn("countryREG18", true);
            this.destController.setHeaderColumnName("addressREG18", "address");
            this.destController.setHeaderColumnName("cityREG18", "city");
            this.destController.setHeaderColumnName("zipREG18", "zip");
            this.destController.setHeaderColumnName("provinceREG18", "province");
            this.destController.setHeaderColumnName("countryREG18", "country");
            this.destController.setPreferredWidthColumn("descriptionREG18", 200);
            this.destController.setFramePreferedSize(new Dimension(750, 500));
            this.destController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    DetailSaleDocVO vo = (DetailSaleDocVO)form.getVOModel().getValueObject();
                    SaleWarehousePanel.this.destDataLocator.getLookupFrameParams().put("SUBJECT_PK", new SubjectPK(vo.getCompanyCodeSys01DOC01(), vo.getProgressiveReg04DOC01()));
                    SaleWarehousePanel.this.destDataLocator.getLookupValidationParameters().put("SUBJECT_PK", new SubjectPK(vo.getCompanyCodeSys01DOC01(), vo.getProgressiveReg04DOC01()));
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    DetailSaleDocVO vo = (DetailSaleDocVO)form.getVOModel().getValueObject();
                    if (vo.getWarehouseCodeWar01DOC01() == null || vo.getWarehouseCodeWar01DOC01().equals("")) {
                        vo.setDescriptionWar01DOC01(null);
                        vo.setAddressDOC01(null);
                        vo.setCityDOC01(null);
                        vo.setProvinceDOC01(null);
                        vo.setZipDOC01(null);
                        vo.setCountryDOC01(null);
                    }
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LookupController getWareController() {
        return this.wareController;
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.labelWarehouseCode.setText("warehouseCodeWAR01");
        this.titledBorder1.setTitle(ClientSettings.getInstance().getResources().getResource("warehouse"));
        this.titledBorder1.setTitleColor(Color.blue);
        this.setBorder(this.titledBorder1);
        this.setLayout(this.gridBagLayout1);
        this.controlWarehouseCode.setAttributeName("warehouseCodeWar01DOC01");
        this.controlWarehouseCode.setCanCopy(true);
        this.controlWarehouseCode.setLinkLabel(this.labelWarehouseCode);
        this.controlWarehouseCode.setMaxCharacters(20);
        this.controlWarehouseCode.setRequired(true);
        this.controlAddress.setEnabledOnInsert(false);
        this.controlAddress.setEnabledOnEdit(false);
        this.controlDescr.setCanCopy(true);
        this.controlDescr.setEnabledOnInsert(false);
        this.controlDescr.setEnabledOnEdit(false);
        this.controlCity.setEnabledOnInsert(false);
        this.controlCity.setEnabledOnEdit(false);
        this.controlZip.setEnabledOnInsert(false);
        this.controlZip.setEnabledOnEdit(false);
        this.controlCountry.setEnabledOnInsert(false);
        this.controlCountry.setEnabledOnEdit(false);
        this.controlProv.setEnabledOnInsert(false);
        this.controlProv.setEnabledOnEdit(false);
        this.labelDest.setText("destinationCodeREG18");
        this.controlDestCode.setAttributeName("destinationCodeReg18DOC01");
        this.controlDestCode.setLinkLabel(this.labelDest);
        this.controlDestCode.setMaxCharacters(20);
        this.controlDestDescr.setEnabledOnInsert(false);
        this.controlDestDescr.setEnabledOnEdit(false);
        this.controlDestDescr.setAttributeName("descriptionDOC01");
        this.add((Component)this.labelWarehouseCode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.controlZip.setAttributeName("zipDOC01");
        this.controlZip.setCanCopy(true);
        this.controlZip.setLinkLabel(this.labelZip);
        this.controlZip.setMaxCharacters(20);
        this.controlProv.setAttributeName("provinceDOC01");
        this.controlProv.setCanCopy(true);
        this.controlProv.setLinkLabel(this.labelProv);
        this.controlProv.setMaxCharacters(20);
        this.controlProv.setTrimText(true);
        this.controlProv.setUpperCase(true);
        this.controlCity.setAttributeName("cityDOC01");
        this.controlCity.setCanCopy(true);
        this.controlCity.setLinkLabel(this.labelCity);
        this.controlAddress.setAttributeName("addressDOC01");
        this.controlAddress.setCanCopy(true);
        this.controlAddress.setLinkLabel(this.labelAddress);
        this.labelAddress.setText("address");
        this.controlCountry.setAttributeName("countryDOC01");
        this.controlCountry.setCanCopy(true);
        this.controlCountry.setLinkLabel(this.labelCountry);
        this.controlCountry.setMaxCharacters(20);
        this.controlCountry.setTrimText(true);
        this.controlCountry.setUpperCase(true);
        this.labelZip.setText("zip");
        this.labelCity.setText("city");
        this.labelCountry.setText("country");
        this.labelProv.setText("prov");
        this.controlDescr.setAttributeName("descriptionWar01DOC01");
        this.controlDescr.setRequired(true);
        this.add((Component)this.labelZip, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelCity, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelAddress, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.controlAddress, new GridBagConstraints(2, 2, 8, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlCity, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 100, 0));
        this.add((Component)this.controlZip, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlWarehouseCode, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.controlDescr, new GridBagConstraints(3, 0, 7, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelDest, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlDestCode, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlDestDescr, new GridBagConstraints(3, 1, 7, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelProv, new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlProv, new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelCountry, new GridBagConstraints(8, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlCountry, new GridBagConstraints(9, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }
}

