/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.headerdiscounts.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.sales.documents.headerdiscounts.client.SaleDocDiscountsPanel;
import org.jallinone.sales.documents.headerdiscounts.java.SaleDocDiscountVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class SaleDocDiscountsController
extends CompanyGridController {
    private SaleDocDiscountsPanel panel = null;

    public SaleDocDiscountsController(SaleDocDiscountsPanel panel) {
        this.panel = panel;
    }

    public void afterDeleteGrid() {
        this.panel.getParentFrame().getHeaderFormPanel().setMode(0);
        this.panel.getParentFrame().getHeaderFormPanel().executeReload();
    }

    public void afterEditGrid(GridControl grid) {
        this.panel.getParentFrame().getHeaderFormPanel().setMode(0);
        this.panel.getParentFrame().getHeaderFormPanel().executeReload();
    }

    public void afterInsertGrid(GridControl grid) {
        this.panel.getParentFrame().getHeaderFormPanel().setMode(0);
        this.panel.getParentFrame().getHeaderFormPanel().executeReload();
    }

    public boolean beforeDeleteGrid(GridControl grid) {
        if (!super.beforeDeleteGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC01().equals("C");
    }

    public boolean beforeEditGrid(GridControl grid) {
        if (!super.beforeEditGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC01().equals("C");
    }

    public boolean beforeInsertData(GridControl grid) {
        if (!super.beforeInsertGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC01().equals("C");
    }

    private Response checkDiscount(SaleDocDiscountVO vo) {
        if (vo.getValueDOC05() == null && vo.getPercDOC05() == null) {
            return new ErrorResponse("you must define a discount as value or as a percentage");
        }
        return new VOResponse((Object)Boolean.TRUE);
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        SaleDocDiscountVO vo = (SaleDocDiscountVO)valueObject;
        vo.setCompanyCodeSys01DOC05(this.panel.getParentVO().getCompanyCodeSys01DOC01());
        vo.setDocTypeDOC05(this.panel.getParentVO().getDocTypeDOC01());
        vo.setDocYearDOC05(this.panel.getParentVO().getDocYearDOC01());
        vo.setDocNumberDOC05(this.panel.getParentVO().getDocNumberDOC01());
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteSaleDocDiscounts", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        SaleDocDiscountVO vo = null;
        Response res = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (SaleDocDiscountVO)((Object)newValueObjects.get(i));
            res = this.checkDiscount(vo);
            if (res.isError()) {
                return res;
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertSaleDocDiscounts", (Object)newValueObjects);
    }

    public boolean isCellEditable(GridControl grid, int row, String attributeName) {
        SaleDocDiscountVO vo = (SaleDocDiscountVO)grid.getVOListTableModel().getObjectForRow(row);
        if (attributeName.equals("valueDOC05") && vo.getMinValueDOC05() == null) {
            return false;
        }
        if (attributeName.equals("percDOC05") && vo.getMinPercDOC05() == null) {
            return false;
        }
        return grid.isFieldEditable(row, attributeName);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        SaleDocDiscountVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (SaleDocDiscountVO)((Object)persistentObjects.get(i));
            Response res = this.checkDiscount(vo);
            if (res.isError()) {
                return res;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateSaleDocDiscounts", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        SaleDocDiscountVO vo = (SaleDocDiscountVO)this.panel.getGrid().getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("valueDOC05") && newValue != null) {
            if (vo.getPercDOC05() != null) {
                vo.setPercDOC05(null);
            }
            if (((BigDecimal)newValue).doubleValue() < vo.getMinValueDOC05().doubleValue()) {
                return false;
            }
            if (((BigDecimal)newValue).doubleValue() > vo.getMaxValueDOC05().doubleValue()) {
                return false;
            }
        } else if (attributeName.equals("percDOC05") && newValue != null) {
            if (vo.getValueDOC05() != null) {
                vo.setValueDOC05(null);
            }
            if (((BigDecimal)newValue).doubleValue() < vo.getMinPercDOC05().doubleValue()) {
                return false;
            }
            if (((BigDecimal)newValue).doubleValue() > vo.getMaxPercDOC05().doubleValue()) {
                return false;
            }
        }
        return true;
    }
}

