/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.headerdiscounts.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jallinone.sales.documents.client.SaleDocument;
import org.jallinone.sales.documents.headerdiscounts.client.SaleDocDiscountsController;
import org.jallinone.sales.documents.headerdiscounts.java.SaleDocDiscountVO;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.jallinone.sales.documents.java.SaleDocPK;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GenericButtonController;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.CurrencyColumn;
import org.openswing.swing.table.columns.client.CurrencyColumnSettings;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.DecimalColumnSettings;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;

public class SaleDocDiscountsPanel
extends JPanel
implements CurrencyColumnSettings {
    BorderLayout borderLayout1;
    GridBagLayout borderLayout2 = new GridBagLayout();
    JPanel buttonsPanel;
    CodLookupColumn colDiscountCode;
    TextColumn colDiscountDescr;
    DecimalColumn colMaxPerc;
    CurrencyColumn colMaxValue;
    DecimalColumn colMinPerc;
    CurrencyColumn colMinValue;
    DecimalColumn colPerc;
    CurrencyColumn colValue;
    DeleteButton deleteButton1;
    LookupController discountController;
    LookupServerDataLocator discountDataLocator;
    EditButton editButton1;
    private boolean enabledInsertEdit;
    ExportButton exportButton;
    FlowLayout flowLayout1;
    GridControl grid;
    GridBagLayout gridBagLayout1;
    ServerGridDataLocator gridDataLocator;
    InsertButton insertButton1;
    NavigatorBar navigatorBar;
    private SaleDocument parentFrame = null;
    private DetailSaleDocVO parentVO = null;
    ReloadButton reloadButton;
    SaveButton saveButton1;
    TitledBorder titledBorder2;
    JPanel topPanel = new JPanel();

    public SaleDocDiscountsPanel(SaleDocument parentFrame, boolean enabledInsertEdit) {
        this.gridBagLayout1 = new GridBagLayout();
        this.grid = new GridControl();
        this.buttonsPanel = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.reloadButton = new ReloadButton();
        this.exportButton = new ExportButton();
        this.navigatorBar = new NavigatorBar();
        this.discountDataLocator = new LookupServerDataLocator();
        this.discountController = new LookupController();
        this.gridDataLocator = new ServerGridDataLocator();
        this.borderLayout1 = new BorderLayout();
        this.insertButton1 = new InsertButton();
        this.editButton1 = new EditButton();
        this.saveButton1 = new SaveButton();
        this.deleteButton1 = new DeleteButton();
        this.colDiscountCode = new CodLookupColumn();
        this.colDiscountDescr = new TextColumn();
        this.colValue = new CurrencyColumn();
        this.colMinValue = new CurrencyColumn();
        this.colMaxValue = new CurrencyColumn();
        this.colPerc = new DecimalColumn();
        this.colMinPerc = new DecimalColumn();
        this.colMaxPerc = new DecimalColumn();
        this.parentFrame = parentFrame;
        this.enabledInsertEdit = enabledInsertEdit;
        try {
            this.jbInit();
            this.init();
            this.grid.setController((GridController)new SaleDocDiscountsController(this));
            this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
            this.gridDataLocator.setServerMethodName("loadSaleDocDiscounts");
            this.discountDataLocator.setGridMethodName("loadSaleHeaderDiscounts");
            this.discountDataLocator.setValidationMethodName("validateSaleHeaderDiscountCode");
            this.colDiscountCode.setLookupController(this.discountController);
            this.discountController.setLookupDataLocator((LookupDataLocator)this.discountDataLocator);
            this.discountController.setFrameTitle("customer discounts");
            this.discountController.setLookupValueObjectClassName("org.jallinone.sales.discounts.java.DiscountVO");
            this.discountController.addLookup2ParentLink("discountCodeSAL03", "discountCodeSal03DOC05");
            this.discountController.addLookup2ParentLink("descriptionSYS10", "discountDescriptionDOC05");
            this.discountController.addLookup2ParentLink("minValueSAL03", "minValueDOC05");
            this.discountController.addLookup2ParentLink("maxValueSAL03", "maxValueDOC05");
            this.discountController.addLookup2ParentLink("minPercSAL03", "minPercDOC05");
            this.discountController.addLookup2ParentLink("maxPercSAL03", "maxPercDOC05");
            this.discountController.addLookup2ParentLink("startDateSAL03", "startDateDOC05");
            this.discountController.addLookup2ParentLink("endDateSAL03", "endDateDOC05");
            this.discountController.setAllColumnVisible(false);
            this.discountController.setVisibleColumn("discountCodeSAL03", true);
            this.discountController.setVisibleColumn("descriptionSYS10", true);
            this.discountController.setVisibleColumn("minValueSAL03", true);
            this.discountController.setVisibleColumn("maxValueSAL03", true);
            this.discountController.setVisibleColumn("minPercSAL03", true);
            this.discountController.setVisibleColumn("maxPercSAL03", true);
            this.discountController.setVisibleColumn("startDateSAL03", true);
            this.discountController.setVisibleColumn("endDateSAL03", true);
            this.discountController.setPreferredWidthColumn("descriptionSYS10", 200);
            this.discountController.setPreferredWidthColumn("minValueSAL03", 70);
            this.discountController.setPreferredWidthColumn("maxValueSAL03", 70);
            this.discountController.setPreferredWidthColumn("minPercSAL03", 70);
            this.discountController.setPreferredWidthColumn("maxPercSAL03", 70);
            this.discountController.setFramePreferedSize(new Dimension(650, 500));
            this.discountController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    SaleDocDiscountVO vo = (SaleDocDiscountVO)parentVO;
                    if (vo.getDiscountCodeSal03DOC05() == null || vo.getDiscountCodeSal03DOC05().equals("")) {
                        vo.setValueDOC05(null);
                        vo.setPercDOC05(null);
                    } else {
                        vo.setValueDOC05(vo.getMinValueDOC05());
                        vo.setPercDOC05(null);
                    }
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.colValue.setDynamicSettings((DecimalColumnSettings)this);
            this.colMinValue.setDynamicSettings((DecimalColumnSettings)this);
            this.colMaxValue.setDynamicSettings((DecimalColumnSettings)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCurrencySymbol(int int0) {
        if (this.parentVO != null) {
            return this.parentVO.getCurrencySymbolREG03();
        }
        return "E";
    }

    public int getDecimals(int int0) {
        if (this.parentVO != null) {
            return this.parentVO.getDecimalsREG03().intValue();
        }
        return 0;
    }

    public GridControl getGrid() {
        return this.grid;
    }

    public double getMaxValue(int int0) {
        return Double.MAX_VALUE;
    }

    public double getMinValue(int int0) {
        return 0.0;
    }

    public SaleDocument getParentFrame() {
        return this.parentFrame;
    }

    public final DetailSaleDocVO getParentVO() {
        return this.parentVO;
    }

    private void init() {
        HashSet<Object> buttonsToDisable = new HashSet<Object>();
        buttonsToDisable.add(this.insertButton1);
        buttonsToDisable.add(this.editButton1);
        buttonsToDisable.add(this.deleteButton1);
        this.grid.addButtonsNotEnabled(buttonsToDisable, (GenericButtonController)this.parentFrame);
    }

    public boolean isGrouping(int int0) {
        return true;
    }

    private void jbInit() throws Exception {
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.reloadButton.setEnabled(false);
        this.titledBorder2 = new TitledBorder("");
        this.setLayout(this.borderLayout1);
        this.topPanel.setLayout(this.gridBagLayout1);
        this.grid.setAutoLoadData(false);
        if (this.enabledInsertEdit) {
            this.grid.setInsertButton(this.insertButton1);
            this.grid.setEditButton(this.editButton1);
        }
        this.grid.setDeleteButton(this.deleteButton1);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("DOC01_ORDERS");
        this.grid.setMaxSortedColumns(3);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton1);
        this.grid.setValueObjectClassName("org.jallinone.sales.documents.headerdiscounts.java.SaleDocDiscountVO");
        this.grid.setVisibleStatusPanel(false);
        this.setBorder(this.titledBorder2);
        this.titledBorder2.setTitle(ClientSettings.getInstance().getResources().getResource("customer discounts"));
        this.titledBorder2.setTitleColor(Color.blue);
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.colDiscountCode.setEditableOnInsert(true);
        this.colDiscountCode.setColumnName("discountCodeSal03DOC05");
        this.colDiscountCode.setPreferredWidth(80);
        this.colDiscountCode.setSortVersus("ASC");
        this.colDiscountCode.setMaxCharacters(20);
        this.colDiscountDescr.setColumnName("discountDescriptionDOC05");
        this.colDiscountDescr.setPreferredWidth(200);
        this.colValue.setColumnName("valueDOC05");
        this.colValue.setColumnRequired(false);
        this.colValue.setEditableOnEdit(true);
        this.colValue.setEditableOnInsert(true);
        this.colValue.setPreferredWidth(80);
        this.colMinValue.setColumnName("minValueDOC05");
        this.colMinValue.setColumnRequired(false);
        this.colMinValue.setPreferredWidth(60);
        this.colMaxValue.setColumnName("maxValueDOC05");
        this.colMaxValue.setColumnRequired(false);
        this.colMaxValue.setPreferredWidth(60);
        this.colPerc.setColumnName("percDOC05");
        this.colPerc.setColumnRequired(false);
        this.colPerc.setEditableOnEdit(true);
        this.colPerc.setEditableOnInsert(true);
        this.colPerc.setPreferredWidth(80);
        this.colPerc.setGrouping(false);
        this.colMinPerc.setColumnName("minPercDOC05");
        this.colMinPerc.setColumnRequired(false);
        this.colMinPerc.setPreferredWidth(60);
        this.colMaxPerc.setColumnName("maxPercDOC05");
        this.colMaxPerc.setColumnRequired(false);
        this.colMaxPerc.setPreferredWidth(60);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)this.colDiscountCode, null);
        this.grid.getColumnContainer().add((Component)this.colDiscountDescr, null);
        this.grid.getColumnContainer().add((Component)this.colValue, null);
        this.grid.getColumnContainer().add((Component)this.colMinValue, null);
        this.grid.getColumnContainer().add((Component)this.colMaxValue, null);
        this.grid.getColumnContainer().add((Component)this.colPerc, null);
        this.grid.getColumnContainer().add((Component)this.colMinPerc, null);
        this.grid.getColumnContainer().add((Component)this.colMaxPerc, null);
        this.topPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.enabledInsertEdit) {
            this.buttonsPanel.add((Component)this.insertButton1, null);
            this.buttonsPanel.add((Component)this.editButton1, null);
            this.buttonsPanel.add((Component)this.saveButton1, null);
        }
        this.buttonsPanel.add((Component)this.reloadButton, null);
        this.buttonsPanel.add((Component)this.deleteButton1, null);
        this.buttonsPanel.add((Component)this.exportButton, null);
        this.buttonsPanel.add((Component)this.navigatorBar, null);
    }

    public final void setEnabled(boolean enabled) {
        this.navigatorBar.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
        if (!enabled) {
            this.grid.clearData();
            this.reloadButton.setEnabled(enabled);
            this.insertButton1.setEnabled(enabled);
            this.editButton1.setEnabled(enabled);
            this.deleteButton1.setEnabled(enabled);
            this.saveButton1.setEnabled(enabled);
            this.reloadButton.setEnabled(enabled);
        } else {
            this.insertButton1.setEnabled(enabled);
            this.editButton1.setEnabled(enabled);
            this.deleteButton1.setEnabled(enabled);
            this.reloadButton.setEnabled(enabled);
        }
    }

    public void setParentVO(DetailSaleDocVO parentVO) {
        this.parentVO = parentVO;
        this.discountDataLocator.getLookupFrameParams().put("SALE_DOC_VO", parentVO);
        this.discountDataLocator.getLookupValidationParameters().put("SALE_DOC_VO", parentVO);
        this.grid.getOtherGridParams().put("SALE_DOC_PK", new SaleDocPK(parentVO.getCompanyCodeSys01DOC01(), parentVO.getDocTypeDOC01(), parentVO.getDocYearDOC01(), parentVO.getDocNumberDOC01()));
    }
}

