/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.itemdiscounts.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.sales.documents.itemdiscounts.client.SaleDocRowDiscountsPanel;
import org.jallinone.sales.documents.itemdiscounts.java.SaleItemDiscountVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class SaleDocRowDiscountsController
extends CompanyGridController {
    private SaleDocRowDiscountsPanel panel = null;

    public SaleDocRowDiscountsController(SaleDocRowDiscountsPanel panel) {
        this.panel = panel;
    }

    public void afterDeleteGrid() {
        this.panel.getParentGrid().reloadData();
        this.panel.getParentDetail().reload();
        this.panel.getParentFrame().getHeaderFormPanel().setMode(0);
        this.panel.getParentFrame().getHeaderFormPanel().executeReload();
    }

    public void afterEditGrid(GridControl grid) {
        this.panel.getParentGrid().reloadData();
        this.panel.getParentDetail().reload();
        this.panel.getParentFrame().getHeaderFormPanel().setMode(0);
        this.panel.getParentFrame().getHeaderFormPanel().executeReload();
    }

    public void afterInsertGrid(GridControl grid) {
        this.panel.getParentGrid().reloadData();
        this.panel.getParentDetail().reload();
        this.panel.getParentFrame().getHeaderFormPanel().setMode(0);
        this.panel.getParentFrame().getHeaderFormPanel().executeReload();
    }

    public boolean beforeDeleteGrid(GridControl grid) {
        if (!super.beforeDeleteGrid(grid)) {
            return false;
        }
        return !this.panel.getParentFrame().getParentVO().getDocStateDOC01().equals("C");
    }

    public boolean beforeEditGrid(GridControl grid) {
        if (!super.beforeEditGrid(grid)) {
            return false;
        }
        return !this.panel.getParentFrame().getParentVO().getDocStateDOC01().equals("C");
    }

    public boolean beforeInsertData(GridControl grid) {
        if (!super.beforeInsertGrid(grid)) {
            return false;
        }
        return !this.panel.getParentFrame().getParentVO().getDocStateDOC01().equals("C");
    }

    private Response checkDiscount(SaleItemDiscountVO vo) {
        if (vo.getValueDOC04() == null && vo.getPercDOC04() == null) {
            return new ErrorResponse("you must define a discount as value or as a percentage");
        }
        return new VOResponse((Object)Boolean.TRUE);
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        SaleItemDiscountVO vo = (SaleItemDiscountVO)valueObject;
        vo.setCompanyCodeSys01DOC04(this.panel.getParentVO().getCompanyCodeSys01DOC02());
        vo.setDocTypeDOC04(this.panel.getParentVO().getDocTypeDOC02());
        vo.setDocYearDOC04(this.panel.getParentVO().getDocYearDOC02());
        vo.setDocNumberDOC04(this.panel.getParentVO().getDocNumberDOC02());
        vo.setItemCodeItm01DOC04(this.panel.getParentVO().getItemCodeItm01DOC02());
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteSaleDocRowDiscounts", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        SaleItemDiscountVO vo = null;
        Response res = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (SaleItemDiscountVO)((Object)newValueObjects.get(i));
            res = this.checkDiscount(vo);
            if (res.isError()) {
                return res;
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertSaleDocRowDiscounts", (Object)newValueObjects);
    }

    public boolean isCellEditable(GridControl grid, int row, String attributeName) {
        SaleItemDiscountVO vo = (SaleItemDiscountVO)grid.getVOListTableModel().getObjectForRow(row);
        if (attributeName.equals("valueDOC04") && vo.getMinValueDOC04() == null) {
            return false;
        }
        if (attributeName.equals("percDOC04") && vo.getMinPercDOC04() == null) {
            return false;
        }
        return grid.isFieldEditable(row, attributeName);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        SaleItemDiscountVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (SaleItemDiscountVO)((Object)persistentObjects.get(i));
            Response res = this.checkDiscount(vo);
            if (res.isError()) {
                return res;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateSaleDocRowDiscounts", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        SaleItemDiscountVO vo = (SaleItemDiscountVO)this.panel.getGrid().getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("valueDOC04") && newValue != null) {
            if (vo.getPercDOC04() != null) {
                vo.setPercDOC04(null);
            }
            if (((BigDecimal)newValue).doubleValue() < vo.getMinValueDOC04().doubleValue()) {
                return false;
            }
            if (((BigDecimal)newValue).doubleValue() > vo.getMaxValueDOC04().doubleValue()) {
                return false;
            }
        } else if (attributeName.equals("percDOC04") && newValue != null) {
            if (vo.getValueDOC04() != null) {
                vo.setValueDOC04(null);
            }
            if (((BigDecimal)newValue).doubleValue() < vo.getMinPercDOC04().doubleValue()) {
                return false;
            }
            if (((BigDecimal)newValue).doubleValue() > vo.getMaxPercDOC04().doubleValue()) {
                return false;
            }
        }
        return true;
    }
}

