/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.pricelist.client;

import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.sales.pricelist.client.PricelistFrame;
import org.jallinone.sales.pricelist.java.PricelistVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class PricelistController
extends CompanyGridController {
    private boolean firstTime = true;
    private PricelistFrame frame = new PricelistFrame(this);
    private String oldCompanyCodeSys01SAL01 = null;
    private String oldPricelistCodeSAL01 = null;

    public PricelistController() {
        MDIFrame.add((InternalFrame)this.frame, (boolean)true);
    }

    public boolean beforeCopyGrid(GridControl grid) {
        boolean ok = super.beforeCopyGrid(grid);
        if (!ok) {
            return false;
        }
        PricelistVO vo = (PricelistVO)this.frame.getGrid().getVOListTableModel().getObjectForRow(this.frame.getGrid().getSelectedRow());
        this.oldCompanyCodeSys01SAL01 = vo.getCompanyCodeSys01SAL01();
        this.oldPricelistCodeSAL01 = vo.getPricelistCodeSAL01();
        return true;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response res = ClientUtils.getData((String)"deletePricelist", (Object)persistentObjects);
        if (!res.isError()) {
            this.frame.getPricesGrid().clearData();
            this.frame.setPricesPanelEnabled(false);
        }
        return res;
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        PricelistVO vo = (PricelistVO)persistentObject;
        this.frame.setPricesPanelEnabled(true);
        this.frame.getPricesGrid().getOtherGridParams().put("PRICELIST", vo);
        this.frame.getTreeLevelDataLocator().getTreeNodeParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01SAL01());
        this.frame.getPricesGrid().reloadData();
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        PricelistVO vo = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (PricelistVO)((Object)newValueObjects.get(i));
            vo.setOldPricelistCodeSal01SAL02(this.oldPricelistCodeSAL01);
            ++i;
        }
        Response res = ClientUtils.getData((String)"insertPricelists", (Object)newValueObjects);
        if (!res.isError()) {
            this.doubleClick(0, (ValueObject)((VOListResponse)res).getRows().get(0));
        }
        this.oldCompanyCodeSys01SAL01 = null;
        this.oldPricelistCodeSAL01 = null;
        return res;
    }

    public void loadDataCompleted(boolean error) {
        if (this.firstTime && !error) {
            this.firstTime = false;
            if (this.frame.getGrid().getVOListTableModel().getRowCount() > 0) {
                this.doubleClick(0, this.frame.getGrid().getVOListTableModel().getObjectForRow(0));
            }
        }
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updatePricelists", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

