/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.activities.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.jallinone.scheduler.activities.client.ScheduledResourcesPanel;
import org.jallinone.scheduler.activities.java.ScheduledActivityPK;
import org.jallinone.scheduler.activities.java.ScheduledEmployeeVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientUtils;

public class ScheduledEmployeesController
extends GridController {
    private GridControl grid = null;
    private ScheduledResourcesPanel panel = null;

    public ScheduledEmployeesController(GridControl grid, ScheduledResourcesPanel panel) {
        this.grid = grid;
        this.panel = panel;
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        ScheduledEmployeeVO vo = (ScheduledEmployeeVO)valueObject;
        ScheduledActivityPK pk = (ScheduledActivityPK)this.grid.getOtherGridParams().get("SCHEDULED_ACTIVITY_PK");
        vo.setCompanyCodeSys01SCH07(pk.getCompanyCodeSys01SCH06());
        vo.setProgressiveSch06SCH07(pk.getProgressiveSCH06());
        vo.setStartDateSCH07(this.panel.getActVO().getStartDateSCH06());
        vo.setEndDateSCH07(this.panel.getActVO().getEstimatedEndDateSCH06());
        vo.setDurationSCH07(this.panel.getActVO().getEstimatedDurationSCH06());
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteScheduledEmployees", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        return ClientUtils.getData((String)"insertScheduledEmployees", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        ScheduledEmployeeVO oldVO = null;
        ScheduledEmployeeVO newVO = null;
        Response res = null;
        int i = 0;
        while (i < oldPersistentObjects.size()) {
            oldVO = (ScheduledEmployeeVO)((Object)oldPersistentObjects.get(i));
            newVO = (ScheduledEmployeeVO)((Object)persistentObjects.get(i));
            if (oldVO.getEmployeeCodeSCH01() == null) {
                ArrayList<ScheduledEmployeeVO> list = new ArrayList<ScheduledEmployeeVO>();
                list.add(newVO);
                res = ClientUtils.getData((String)"insertScheduledEmployees", list);
                if (res.isError()) {
                    return res;
                }
                persistentObjects.set(i, ((VOListResponse)res).getRows().get(0));
                oldPersistentObjects.set(i, ((VOListResponse)res).getRows().get(0));
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateScheduledEmployees", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        ScheduledEmployeeVO vo = (ScheduledEmployeeVO)this.grid.getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("endDateSCH07") && newValue != null && vo.getStartDateSCH07() != null) {
            vo.setDurationSCH07(new BigDecimal((double)((((Date)newValue).getTime() - vo.getStartDateSCH07().getTime()) / 1000L / 60L)));
        } else if (attributeName.equals("startDateSCH07") && newValue != null && vo.getEndDateSCH07() != null) {
            vo.setDurationSCH07(new BigDecimal((double)((vo.getEndDateSCH07().getTime() - ((Date)newValue).getTime()) / 1000L / 60L)));
        } else if (attributeName.equals("durationSCH07") && newValue != null && vo.getStartDateSCH07() != null) {
            vo.setEndDateSCH07(new Timestamp(vo.getStartDateSCH07().getTime() + ((BigDecimal)newValue).longValue() * 1000L * 60L));
        }
        return true;
    }
}

