/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.activities.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.jallinone.scheduler.activities.client.ScheduledResourcesPanel;
import org.jallinone.scheduler.activities.java.ScheduledActivityPK;
import org.jallinone.scheduler.activities.java.ScheduledMachineriesVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientUtils;

public class ScheduledMachineriesController
extends GridController {
    private GridControl grid = null;
    private ScheduledResourcesPanel panel = null;

    public ScheduledMachineriesController(GridControl grid, ScheduledResourcesPanel panel) {
        this.grid = grid;
        this.panel = panel;
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        ScheduledMachineriesVO vo = (ScheduledMachineriesVO)valueObject;
        ScheduledActivityPK pk = (ScheduledActivityPK)this.grid.getOtherGridParams().get("SCHEDULED_ACTIVITY_PK");
        vo.setCompanyCodeSys01SCH09(pk.getCompanyCodeSys01SCH06());
        vo.setProgressiveSch06SCH09(pk.getProgressiveSCH06());
        vo.setStartDateSCH09(this.panel.getActVO().getStartDateSCH06());
        vo.setEndDateSCH09(this.panel.getActVO().getEstimatedEndDateSCH06());
        vo.setDurationSCH09(this.panel.getActVO().getEstimatedDurationSCH06());
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteScheduledMachineries", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        return ClientUtils.getData((String)"insertScheduledMachineries", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        ScheduledMachineriesVO oldVO = null;
        ScheduledMachineriesVO newVO = null;
        Response res = null;
        int i = 0;
        while (i < oldPersistentObjects.size()) {
            oldVO = (ScheduledMachineriesVO)((Object)oldPersistentObjects.get(i));
            newVO = (ScheduledMachineriesVO)((Object)persistentObjects.get(i));
            if (oldVO.getStartDateSCH09() == null) {
                res = ClientUtils.getData((String)"insertScheduledMachinery", (Object)((Object)newVO));
                if (res.isError()) {
                    return res;
                }
                persistentObjects.set(i, ((VOResponse)res).getVo());
                oldPersistentObjects.set(i, ((VOResponse)res).getVo());
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateScheduledMachineries", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        ScheduledMachineriesVO vo = (ScheduledMachineriesVO)this.grid.getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("endDateSCH09") && newValue != null && vo.getStartDateSCH09() != null) {
            vo.setDurationSCH09(new BigDecimal((double)((((Date)newValue).getTime() - vo.getStartDateSCH09().getTime()) / 1000L / 60L)));
        } else if (attributeName.equals("startDateSCH09") && newValue != null && vo.getEndDateSCH09() != null) {
            vo.setDurationSCH09(new BigDecimal((double)((vo.getEndDateSCH09().getTime() - ((Date)newValue).getTime()) / 1000L / 60L)));
        } else if (attributeName.equals("durationSCH09") && newValue != null && vo.getStartDateSCH09() != null) {
            vo.setEndDateSCH09(new Timestamp(vo.getStartDateSCH09().getTime() + ((BigDecimal)newValue).longValue() * 1000L * 60L));
        }
        return true;
    }
}

