/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.appointments.client;

import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.jallinone.employees.java.DetailEmployeeVO;
import org.jallinone.employees.java.GridEmployeeVO;
import org.jallinone.scheduler.activities.java.EmployeeActivityVO;
import org.jallinone.scheduler.appointments.client.Day;
import org.jallinone.scheduler.appointments.client.EmployeeAppointmentsFrame_findButton_actionAdapter;
import org.jallinone.subjects.java.OrganizationVO;
import org.jallinone.subjects.java.PeopleVO;
import org.jallinone.subjects.java.SubjectPK;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class EmployeeAppointmentsFrame
extends InternalFrame {
    BorderLayout borderLayout1;
    JCalendar calendar;
    CardLayout cardLayout2;
    JPanel cardPanel2;
    ComboBoxControl controlActType;
    CodLookupControl controlEmpCode;
    DateControl controlFromDate;
    TextControl controlName1;
    TextControl controlName2;
    TextControl controlName_1;
    TextControl controlName_2;
    ComboBoxControl controlSubjectType;
    Day day;
    JPanel dayPanel;
    JScrollPane dayScrollPane;
    LookupController empController;
    LookupServerDataLocator empDataLocator;
    private DetailEmployeeVO empVO = null;
    CodLookupControl filterOrgButton;
    JPanel filterPanel = new JPanel();
    CodLookupControl filterPeopleButton;
    GenericButton findButton;
    JPanel findPanel;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    LabelControl labelActType;
    LabelControl labelEmp;
    LabelControl labelFromDate;
    LabelControl labelSubjectType;
    LookupController orgController;
    LookupServerDataLocator orgDataLocator;
    LookupController peopleController;
    LookupServerDataLocator peopleDataLocator;
    TitledBorder titledBorder1;

    public EmployeeAppointmentsFrame(BigDecimal progressiveReg04SYS03, String companyCodeSys01SYS03, String empCode, String name_1, String name_2) {
        this.dayPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.borderLayout1 = new BorderLayout();
        this.dayScrollPane = new JScrollPane();
        this.day = new Day();
        this.calendar = new JCalendar();
        this.labelEmp = new LabelControl();
        this.controlEmpCode = new CodLookupControl();
        this.controlName1 = new TextControl();
        this.controlName2 = new TextControl();
        this.empDataLocator = new LookupServerDataLocator();
        this.empController = new LookupController();
        this.findPanel = new JPanel();
        this.gridBagLayout2 = new GridBagLayout();
        this.labelSubjectType = new LabelControl();
        this.filterPeopleButton = new CodLookupControl();
        this.filterOrgButton = new CodLookupControl();
        this.controlName_1 = new TextControl();
        this.controlName_2 = new TextControl();
        this.labelActType = new LabelControl();
        this.controlActType = new ComboBoxControl();
        this.findButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"filter.gif")));
        this.labelFromDate = new LabelControl();
        this.controlFromDate = new DateControl();
        this.controlSubjectType = new ComboBoxControl();
        this.peopleController = new LookupController();
        this.peopleDataLocator = new LookupServerDataLocator();
        this.orgController = new LookupController();
        this.orgDataLocator = new LookupServerDataLocator();
        this.cardLayout2 = new CardLayout();
        this.cardPanel2 = new JPanel();
        try {
            this.jbInit();
            this.init();
            this.calendar.setLocale(new Locale(ClientSettings.getInstance().getResources().getLanguageId()));
            this.calendar.getDayChooser().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(EmployeeAppointmentsFrame.this.calendar.getCalendar().getTime());
                    cal.set(5, cal.get(5) + 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    EmployeeAppointmentsFrame.this.controlFromDate.setValue((Object)cal.getTime());
                    EmployeeAppointmentsFrame.this.day.setCurrentDay(EmployeeAppointmentsFrame.this.calendar.getCalendar().getTime());
                }
            });
            this.empDataLocator.setGridMethodName("loadEmployees");
            this.empDataLocator.setValidationMethodName("validateEmployeeCode");
            this.controlEmpCode.setLookupController(this.empController);
            this.controlEmpCode.setControllerMethodName("getEmployeesList");
            this.empController.setLookupDataLocator((LookupDataLocator)this.empDataLocator);
            this.empController.setFrameTitle("employees");
            this.empController.setLookupValueObjectClassName("org.jallinone.employees.java.GridEmployeeVO");
            this.empController.addLookup2ParentLink("employeeCodeSCH01", "employeeCodeSCH01");
            this.empController.addLookup2ParentLink("companyCodeSys01SCH01", "companyCodeSys01SYS03");
            this.empController.addLookup2ParentLink("name_1REG04", "firstNameSYS03");
            this.empController.addLookup2ParentLink("name_2REG04", "lastNameSYS03");
            this.empController.addLookup2ParentLink("progressiveReg04SCH01", "progressiveReg04SYS03");
            this.empController.setAllColumnVisible(false);
            this.empController.setVisibleColumn("employeeCodeSCH01", true);
            this.empController.setVisibleColumn("name_1REG04", true);
            this.empController.setVisibleColumn("name_2REG04", true);
            this.empController.setPreferredWidthColumn("name_1REG04", 150);
            this.empController.setPreferredWidthColumn("name_2REG04", 150);
            this.empController.setFramePreferedSize(new Dimension(430, 400));
            this.empController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    GridEmployeeVO vo = (GridEmployeeVO)EmployeeAppointmentsFrame.this.empController.getLookupVO();
                    EmployeeAppointmentsFrame.this.controlName1.setValue((Object)vo.getName_1REG04());
                    EmployeeAppointmentsFrame.this.controlName2.setValue((Object)vo.getName_2REG04());
                    EmployeeAppointmentsFrame.this.loadEmployeeDetail(vo.getCompanyCodeSys01SCH01(), vo.getProgressiveReg04SCH01());
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.controlEmpCode.setValue((Object)empCode);
            this.controlName1.setValue((Object)name_1);
            this.controlName2.setValue((Object)name_2);
            this.controlFromDate.setValue((Object)new Date(System.currentTimeMillis()));
            this.setSize(750, 600);
            MDIFrame.getInstance();
            MDIFrame.add((InternalFrame)this, (boolean)true);
            this.loadEmployeeDetail(companyCodeSys01SYS03, progressiveReg04SYS03);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void findButton_actionPerformed(ActionEvent e) {
        Response res;
        GridParams gridPars = new GridParams();
        gridPars.getOtherGridParams().put("COMPANY_CODE_SYS01", this.empVO.getCompanyCodeSys01SCH01());
        gridPars.getOtherGridParams().put("PROGRESSIVE_REG04", this.empVO.getProgressiveReg04SCH01());
        if (this.controlFromDate.getValue() != null) {
            gridPars.getOtherGridParams().put("START_DATE", this.controlFromDate.getValue());
        }
        if (this.controlSubjectType.getValue() != null && this.controlSubjectType.getValue().equals("A")) {
            gridPars.getOtherGridParams().put("PROGRESSIVE_REG04_SUBJECT", this.filterOrgButton.getValue());
        } else if (this.controlSubjectType.getValue() != null && this.controlSubjectType.getValue().equals("B")) {
            gridPars.getOtherGridParams().put("PROGRESSIVE_REG04_SUBJECT", this.filterPeopleButton.getValue());
        }
        if (this.controlActType.getValue() != null) {
            gridPars.getOtherGridParams().put("ACTIVITY_TYPE", "'" + this.controlActType.getValue() + "'");
        }
        if ((res = ClientUtils.getData((String)"loadEmployeeActivities", (Object)gridPars)).isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            return;
        }
        List rows = ((VOListResponse)res).getRows();
        if (rows.size() > 0) {
            EmployeeActivityVO vo = (EmployeeActivityVO)((Object)rows.get(0));
            Calendar cal = Calendar.getInstance();
            cal.setTime(vo.getStartDateSCH07());
            this.calendar.setCalendar(cal);
            cal.setTime(vo.getStartDateSCH07());
            cal.set(5, cal.get(5) + 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.controlFromDate.setValue((Object)cal.getTime());
            this.day.setCurrentDay(vo.getStartDateSCH07());
        } else {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("no appointment found"), ClientSettings.getInstance().getResources().getResource("Attention"), 0);
        }
    }

    private void init() {
        this.peopleDataLocator.setGridMethodName("loadSubjectPerName");
        this.peopleDataLocator.setValidationMethodName("");
        this.filterPeopleButton.setLookupController(this.peopleController);
        this.peopleController.setLookupDataLocator((LookupDataLocator)this.peopleDataLocator);
        this.peopleController.setFrameTitle("people");
        this.peopleController.setLookupValueObjectClassName("org.jallinone.subjects.java.PeopleVO");
        this.peopleController.addLookup2ParentLink("progressiveREG04", "progressiveReg04SubjectSCH06");
        this.peopleController.addLookup2ParentLink("name_1REG04", "subjectName_1SCH06");
        this.peopleController.addLookup2ParentLink("name_2REG04", "subjectName_2SCH06");
        this.peopleController.setAllColumnVisible(false);
        this.peopleController.setVisibleColumn("name_1REG04", true);
        this.peopleController.setVisibleColumn("name_2REG04", true);
        this.peopleController.setVisibleColumn("addressREG04", true);
        this.peopleController.setVisibleColumn("cityREG04", true);
        this.peopleController.setVisibleColumn("provinceREG04", true);
        this.peopleController.setVisibleColumn("countryREG04", true);
        this.peopleController.setVisibleColumn("zipREG04", true);
        this.peopleController.setHeaderColumnName("addressREG04", "address");
        this.peopleController.setHeaderColumnName("cityREG04", "city");
        this.peopleController.setHeaderColumnName("provinceREG04", "prov");
        this.peopleController.setHeaderColumnName("countryREG04", "country");
        this.peopleController.setHeaderColumnName("zipREG04", "zip");
        this.peopleController.setPreferredWidthColumn("name_1REG04", 120);
        this.peopleController.setPreferredWidthColumn("name_2REG04", 120);
        this.peopleController.setPreferredWidthColumn("addressREG04", 200);
        this.peopleController.setPreferredWidthColumn("provinceREG04", 50);
        this.peopleController.setPreferredWidthColumn("countryREG04", 70);
        this.peopleController.setPreferredWidthColumn("zipREG04", 50);
        this.peopleController.setFramePreferedSize(new Dimension(740, 500));
        this.peopleController.addLookupListener(new LookupListener(){

            public void beforeLookupAction(ValueObject parentVO) {
                EmployeeAppointmentsFrame.this.peopleDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", EmployeeAppointmentsFrame.this.empVO.getCompanyCodeSys01REG04());
                EmployeeAppointmentsFrame.this.peopleDataLocator.getLookupFrameParams().put("SUBJECT_TYPE", "B");
            }

            public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                PeopleVO vo = (PeopleVO)EmployeeAppointmentsFrame.this.peopleController.getLookupVO();
                EmployeeAppointmentsFrame.this.controlName_1.setValue((Object)vo.getName_1REG04());
                EmployeeAppointmentsFrame.this.controlName_2.setValue((Object)vo.getName_2REG04());
                EmployeeAppointmentsFrame.this.filterPeopleButton.setValue((Object)vo.getProgressiveREG04());
            }

            public void codeValidated(boolean validated) {
            }

            public void forceValidate() {
            }
        });
        this.orgDataLocator.setGridMethodName("loadSubjectPerName");
        this.orgDataLocator.setValidationMethodName("");
        this.filterOrgButton.setLookupController(this.orgController);
        this.orgController.setLookupDataLocator((LookupDataLocator)this.orgDataLocator);
        this.orgController.setFrameTitle("organizations");
        this.orgController.setLookupValueObjectClassName("org.jallinone.subjects.java.OrganizationVO");
        this.orgController.addLookup2ParentLink("progressiveREG04", "progressiveReg04SubjectSCH06");
        this.orgController.addLookup2ParentLink("name_1REG04", "subjectName_1SCH06");
        this.orgController.addLookup2ParentLink("name_2REG04", "subjectName_2SCH06");
        this.orgController.setAllColumnVisible(false);
        this.orgController.setVisibleColumn("name_1REG04", true);
        this.orgController.setVisibleColumn("addressREG04", true);
        this.orgController.setVisibleColumn("cityREG04", true);
        this.orgController.setVisibleColumn("provinceREG04", true);
        this.orgController.setVisibleColumn("countryREG04", true);
        this.orgController.setVisibleColumn("zipREG04", true);
        this.orgController.setHeaderColumnName("addressREG04", "address");
        this.orgController.setHeaderColumnName("cityREG04", "city");
        this.orgController.setHeaderColumnName("provinceREG04", "prov");
        this.orgController.setHeaderColumnName("countryREG04", "country");
        this.orgController.setHeaderColumnName("zipREG04", "zip");
        this.orgController.setPreferredWidthColumn("name_1REG04", 150);
        this.orgController.setPreferredWidthColumn("addressREG04", 200);
        this.orgController.setPreferredWidthColumn("provinceREG04", 50);
        this.orgController.setPreferredWidthColumn("zipREG04", 50);
        this.orgController.setFramePreferedSize(new Dimension(740, 500));
        this.orgController.addLookupListener(new LookupListener(){

            public void beforeLookupAction(ValueObject parentVO) {
                EmployeeAppointmentsFrame.this.orgDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", EmployeeAppointmentsFrame.this.empVO.getCompanyCodeSys01REG04());
                EmployeeAppointmentsFrame.this.orgDataLocator.getLookupFrameParams().put("SUBJECT_TYPE", "A");
            }

            public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                OrganizationVO vo = (OrganizationVO)EmployeeAppointmentsFrame.this.orgController.getLookupVO();
                EmployeeAppointmentsFrame.this.controlName_1.setValue((Object)vo.getName_1REG04());
                EmployeeAppointmentsFrame.this.controlName_2.setValue((Object)vo.getName_2REG04());
                EmployeeAppointmentsFrame.this.filterOrgButton.setValue((Object)vo.getProgressiveREG04());
            }

            public void codeValidated(boolean validated) {
            }

            public void forceValidate() {
            }
        });
        this.controlSubjectType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (EmployeeAppointmentsFrame.this.controlSubjectType.getComboBox().getSelectedIndex() == -1) {
                    EmployeeAppointmentsFrame.this.controlName_1.setValue((Object)"");
                    EmployeeAppointmentsFrame.this.controlName_2.setValue((Object)"");
                    EmployeeAppointmentsFrame.this.filterOrgButton.setValue(null);
                    EmployeeAppointmentsFrame.this.filterPeopleButton.setValue(null);
                } else if (e.getStateChange() == 1) {
                    EmployeeAppointmentsFrame.this.cardLayout2.show(EmployeeAppointmentsFrame.this.cardPanel2, (String)EmployeeAppointmentsFrame.this.controlSubjectType.getValue());
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.cardPanel2.setLayout(this.cardLayout2);
        this.cardPanel2.add((Component)this.filterOrgButton, "A");
        this.cardPanel2.add((Component)this.filterPeopleButton, "B");
        this.findButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("find next appointment"));
        this.titledBorder1 = new TitledBorder("");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("day appointments"));
        this.filterPanel.setBorder(BorderFactory.createEtchedBorder());
        this.filterPanel.setLayout(this.gridBagLayout1);
        this.dayPanel.setDebugGraphicsOptions(0);
        this.dayPanel.setLayout(this.borderLayout1);
        this.labelEmp.setText("employeeCodeSCH01");
        this.controlName2.setColumns(15);
        this.controlName2.setEnabled(false);
        this.controlName1.setColumns(15);
        this.controlName1.setEnabled(false);
        this.controlName1.setEnabledOnEdit(true);
        this.controlEmpCode.setMaxCharacters(20);
        this.calendar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.findPanel.setBorder(this.titledBorder1);
        this.findPanel.setLayout(this.gridBagLayout2);
        this.titledBorder1.setTitleColor(Color.blue);
        this.titledBorder1.setTitle(ClientSettings.getInstance().getResources().getResource("find appointment"));
        this.labelSubjectType.setText("subject type");
        this.labelActType.setText("activityTypeSCH06");
        this.findButton.addActionListener((ActionListener)new EmployeeAppointmentsFrame_findButton_actionAdapter(this));
        this.filterOrgButton.setAllowOnlyNumbers(true);
        this.filterOrgButton.setCodBoxVisible(false);
        this.filterPeopleButton.setAllowOnlyNumbers(true);
        this.filterPeopleButton.setCodBoxVisible(false);
        this.controlName_1.setEnabled(false);
        this.controlName_2.setEnabled(false);
        this.labelFromDate.setText("from date");
        this.controlSubjectType.setDomainId("SUBJECT_TYPE_2");
        this.getContentPane().add((Component)this.filterPanel, "North");
        this.filterPanel.add((Component)this.calendar, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.labelEmp, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlEmpCode, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlName1, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlName2, new GridBagConstraints(4, 0, 1, 2, 1.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.findPanel, new GridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.dayPanel, "Center");
        this.dayPanel.add((Component)this.dayScrollPane, "Center");
        this.dayScrollPane.getViewport().add((Component)this.day, null);
        this.findPanel.add((Component)this.labelSubjectType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.findPanel.add((Component)this.cardPanel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.findPanel.add((Component)this.controlName_1, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.findPanel.add((Component)this.controlName_2, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.findPanel.add((Component)this.labelActType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.findPanel.add((Component)this.findButton, new GridBagConstraints(4, 1, 1, 2, 0.0, 1.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.findPanel.add((Component)this.labelFromDate, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.findPanel.add((Component)this.controlFromDate, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.findPanel.add((Component)this.controlSubjectType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.findPanel.add((Component)this.controlActType, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 40, 0));
        this.controlActType.setDomainId("ACTIVITY_TYPE");
    }

    private void loadEmployeeDetail(String companyCodeSys01SYS03, BigDecimal progressiveReg04SYS03) {
        Response res = ClientUtils.getData((String)"loadEmployee", (Object)new SubjectPK(companyCodeSys01SYS03, progressiveReg04SYS03));
        if (res.isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
        } else {
            this.empVO = (DetailEmployeeVO)((VOResponse)res).getVo();
        }
        GridParams gridParams = new GridParams();
        gridParams.getOtherGridParams().put("COMPANY_CODE_SYS01", companyCodeSys01SYS03);
        gridParams.getOtherGridParams().put("PROGRESSIVE_REG04", progressiveReg04SYS03);
        res = ClientUtils.getData((String)"loadEmployeeCalendar", (Object)gridParams);
        if (res.isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
        } else {
            this.day.setEmpCalendar(new ArrayList(((VOListResponse)res).getRows()));
        }
        this.day.setEmployeeVO(this.empVO);
        if (this.day.getEmpCalVO() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.day.getEmpCalVO().getMorningStartHourSCH02());
            int startH = cal.get(11);
            int startM = cal.get(12);
            this.dayScrollPane.getVerticalScrollBar().setValue(startH * this.day.hourH + startM * this.day.hourH / 60);
        }
    }
}

