/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.callouts.client;

import java.util.ArrayList;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.scheduler.callouts.client.CallOutFrame;
import org.jallinone.scheduler.callouts.client.CallOutsFrame;
import org.jallinone.scheduler.callouts.java.CallOutPK;
import org.jallinone.scheduler.callouts.java.CallOutVO;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class CallOutController
extends CompanyFormController {
    private CallOutFrame frame = null;
    private CallOutsFrame parentFrame = null;
    private CallOutPK pk = null;

    public CallOutController(CallOutsFrame parentFrame, CallOutPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new CallOutFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getFormPanel().setMode(0);
            this.frame.getFormPanel().executeReload();
        } else {
            this.frame.getFormPanel().insert();
        }
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getTasksGrid().clearData();
            this.frame.getMacsGrid().clearData();
            this.frame.getItemsGrid().clearData();
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject PersistentObject) throws Exception {
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<CallOutPK> pks = new ArrayList<CallOutPK>();
        CallOutVO vo = (CallOutVO)persistentObject;
        CallOutPK pk = new CallOutPK(vo.getCompanyCodeSys01SCH10(), vo.getCallOutCodeSCH10());
        pks.add(pk);
        Response res = ClientUtils.getData((String)"deleteCallOuts", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getTasksGrid().clearData();
            this.frame.getMacsGrid().clearData();
            this.frame.getItemsGrid().clearData();
            this.frame.setButtonsEnabled(false);
        }
        return res;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"insertCallOut", (Object)newPersistentObject);
        if (!res.isError()) {
            CallOutVO vo = (CallOutVO)((Object)((VOResponse)res).getVo());
            this.pk = new CallOutPK(vo.getCompanyCodeSys01SCH10(), vo.getCallOutCodeSCH10());
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getTasksGrid().getOtherGridParams().put("CALL_OUT_PK", this.pk);
            this.frame.getMacsGrid().getOtherGridParams().put("CALL_OUT_PK", this.pk);
            this.frame.getItemsGrid().getOtherGridParams().put("CALL_OUT_PK", this.pk);
            this.frame.setButtonsEnabled(true);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadCallOut", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateCallOut", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError() && this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        return res;
    }
}

